/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.option.gui;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.ui.dialog.option.pm.OptionDialogMailPm;
import ch.transsoft.edec.ui.gui.Design;
import ch.transsoft.edec.ui.gui.control.BooleanField;
import ch.transsoft.edec.ui.gui.control.DefaultPanel;
import ch.transsoft.edec.ui.gui.control.InfoIcon;
import ch.transsoft.edec.ui.gui.control.Label;
import ch.transsoft.edec.ui.gui.control.PasswordField;
import ch.transsoft.edec.ui.gui.control.StringField;
import ch.transsoft.edec.util.RadioButtonUtil;
import java.awt.Component;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;

public class OptionMailPanel
extends DefaultPanel {
    private final BooleanField useSSL;
    private final BooleanField useTLS;
    private final StringField emailAdress;
    private final StringField host;
    private final StringField port;
    private final StringField user;
    private final PasswordField password;
    private final OptionDialogMailPm pm;

    public OptionMailPanel(OptionDialogMailPm pm) {
        this.pm = pm;
        this.setLayout(new MigLayout("fillx", "[grow]", "[]2[]"));
        ButtonGroup group = new ButtonGroup();
        JRadioButton radioOutlook = RadioButtonUtil.createRadioButton(group, this.getText(4155));
        JRadioButton radioSMTP = RadioButtonUtil.createRadioButton(group, this.getText(4168));
        JRadioButton radioTranssoft = RadioButtonUtil.createRadioButton(group, this.getText(4156));
        RadioButtonUtil.connectRadio(pm.getDisposables(), null, pm.getEmailChannel(), radioTranssoft, radioOutlook, radioSMTP);
        this.setGroupBackground(group);
        this.add((Component)new JLabel(Services.getText(4249)), "split");
        this.add((Component)new InfoIcon(Services.getText(4250), true), "wrap");
        this.add((Component)new JSeparator(), "growx, gapy 10, wrap");
        this.add((Component)radioOutlook, "wrap");
        this.add((Component)radioSMTP, "wrap, gapy 5");
        this.emailAdress = new StringField(pm.getSenderEmailAddress());
        this.add((Component)this.emailAdress, "gapx 24, w 200, h 20, split");
        this.add((Component)new Label(this.getText(4175)), "wrap");
        this.host = new StringField(pm.getHost());
        this.add((Component)this.host, "gapx 24, w 200, h 20, split");
        this.add((Component)new Label(this.getText(4169)), "wrap");
        this.port = new StringField(pm.getPort());
        this.add((Component)this.port, "gapx 24, w 200, h 20, split");
        this.add((Component)new Label(this.getText(4170)), "wrap");
        this.useSSL = new BooleanField(pm.getUseSSL(), this.getText(4171));
        this.add((Component)this.useSSL, "gapx 20, wrap");
        this.useTLS = new BooleanField(pm.getUseTLS(), this.getText(4172));
        this.add((Component)this.useTLS, "gapx 20, wrap");
        this.user = new StringField(pm.getUser());
        this.add((Component)this.user, "gapx 24, w 200, h 20, split");
        this.add((Component)new Label(this.getText(4173)), "wrap");
        this.password = new PasswordField(pm.getPassword());
        this.add((Component)this.password, "gapx 24, w 200, h 20, split");
        this.add((Component)new Label(this.getText(4174)), "wrap");
        this.add((Component)radioTranssoft, "wrap, gapy 5");
        this.add((Component)new JSeparator(), "growx, gapy 10, wrap");
        this.add((Component)new BooleanField(pm.getCopyAttachedFilesToSendingFolder(), this.getText(4432)), "split, gapy 5");
        this.add((Component)new InfoIcon(), "wrap");
        this.add((Component)new BooleanField(pm.getAttachSendingXml(), this.getText(4444)), "split");
        this.add((Component)new InfoIcon(), "wrap");
        pm.getDisposables().add(pm.getEmailChannel().addChangeListener((source, info) -> this.updateState()));
        this.updateState();
    }

    private void setGroupBackground(ButtonGroup group) {
        group.getElements().asIterator().forEachRemaining(button -> button.setBackground(Design.BG));
    }

    private void updateState() {
        this.emailAdress.setEnabled(this.pm.isSendViaSMTP());
        this.host.setEnabled(this.pm.isSendViaSMTP());
        this.port.setEnabled(this.pm.isSendViaSMTP());
        this.useSSL.setEnabled(this.pm.isSendViaSMTP());
        this.useTLS.setEnabled(this.pm.isSendViaSMTP());
        this.user.setEnabled(this.pm.isSendViaSMTP());
        this.password.setEnabled(this.pm.isSendViaSMTP());
    }
}

