/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.option.gui.moduleimp;

import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.validate.ErrorMarker;
import ch.transsoft.edec.ui.dialog.option.gui.moduleimp.ImpColTable;
import ch.transsoft.edec.ui.dialog.option.pm.moduleimp.OptionDialogModuleImportPm;
import ch.transsoft.edec.ui.gui.control.BooleanField;
import ch.transsoft.edec.ui.gui.control.DefaultPanel;
import ch.transsoft.edec.ui.gui.control.InfoIcon;
import ch.transsoft.edec.ui.gui.control.Label;
import ch.transsoft.edec.ui.gui.control.StringField;
import java.awt.Component;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;

public class OptionModuleImportPanel
extends DefaultPanel {
    private final OptionDialogModuleImportPm pm;
    private final StringField time;

    public OptionModuleImportPanel(OptionDialogModuleImportPm pm) {
        this.pm = pm;
        this.setLayout(new MigLayout("", "grow", "[]20[]10[]0[grow]"));
        this.add((Component)new BooleanField(pm.getAutoDownload(), this.getText(4434)), "split 3");
        this.time = new StringField(pm.getAutoDownloadTime());
        this.add((Component)this.time, "width 70!");
        this.add(new Label(Services.getText(4435)));
        this.add((Component)new InfoIcon(), "wrap");
        this.add(new BooleanField(pm.getDownloadAfterStartup(), this.getText(4436)));
        this.add((Component)new InfoIcon(), "wrap");
        this.add((Component)new JSeparator(), "wrap, growx");
        this.add((Component)new ImpColTable(Services.getText(1480), pm.getImpColPm()), "grow");
        this.addListener();
        this.updateTimeEnablement();
    }

    private void addListener() {
        this.pm.add(this.pm.getModuleImportInfo().getAutoDownload().addChangeListener((source, info) -> this.updateTimeEnablement()));
        this.pm.add(this.pm.getModuleImportInfo().getDownloadTime().addChangeListener((source, info) -> {
            StringNode node = this.pm.getModuleImportInfo().getDownloadTime();
            if (node.getValue().matches("\\d\\d\\:\\d\\d")) {
                node.removeError();
            } else {
                node.setError(new ErrorMarker("InvalidTimeFormat", node, Services.getText(4437)));
            }
        }));
    }

    private void updateTimeEnablement() {
        this.time.setEnabled(this.pm.getModuleImportInfo().getAutoDownload().getValue());
    }
}

