/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.option.pm;

import ch.transsoft.edec.model.config.conf.options.MailOptionInfo;
import ch.transsoft.edec.model.config.pref.mail.MailPreferenceInfo;
import ch.transsoft.edec.model.infra.node.IntegralNode;
import ch.transsoft.edec.ui.pm.model.BooleanPm;
import ch.transsoft.edec.ui.pm.model.IPm;
import ch.transsoft.edec.ui.pm.model.StringPm;
import ch.transsoft.edec.util.disposable.Disposables;
import ch.transsoft.edec.util.disposable.IDisposable;

public class OptionDialogMailPm
implements IPm,
IDisposable {
    private BooleanPm copyAttachedFilesToSendingFolder;
    private BooleanPm attachSendingXml;
    private BooleanPm useSSL;
    private BooleanPm useTLS;
    private StringPm user;
    private StringPm password;
    private StringPm host;
    private StringPm port;
    private StringPm senderEmailAdress;
    private Disposables disposables = new Disposables();
    private final MailOptionInfo configInfo;
    private MailPreferenceInfo preferenceInfo;

    public OptionDialogMailPm(MailOptionInfo configInfo, MailPreferenceInfo preferenceInfo) {
        this.configInfo = configInfo;
        this.preferenceInfo = preferenceInfo;
        this.copyAttachedFilesToSendingFolder = new BooleanPm(configInfo.getCopyAttachedFilesToSendingFolder());
        this.attachSendingXml = new BooleanPm(configInfo.getAttachSendingXml());
        this.useSSL = new BooleanPm(preferenceInfo.getUseSSL());
        this.useTLS = new BooleanPm(preferenceInfo.getUseTLS());
        this.user = new StringPm(preferenceInfo.getUser());
        this.password = new StringPm(preferenceInfo.getPassword());
        this.host = new StringPm(preferenceInfo.getHost());
        this.port = new StringPm(preferenceInfo.getPort());
        this.senderEmailAdress = new StringPm(preferenceInfo.getSenderEmailAdress());
    }

    public IntegralNode getEmailChannel() {
        return this.preferenceInfo.getEmailChannel();
    }

    public boolean isSendViaOutlook() {
        return this.preferenceInfo.getSendViaOutlook();
    }

    public boolean isSendViaTransSoftServer() {
        return this.preferenceInfo.getSendViaTransSoftServer();
    }

    public boolean isSendViaSMTP() {
        return this.preferenceInfo.getSendViaSMTP();
    }

    public BooleanPm getCopyAttachedFilesToSendingFolder() {
        return this.copyAttachedFilesToSendingFolder;
    }

    public BooleanPm getAttachSendingXml() {
        return this.attachSendingXml;
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }

    public Disposables getDisposables() {
        return this.disposables;
    }

    public BooleanPm getUseSSL() {
        return this.useSSL;
    }

    public BooleanPm getUseTLS() {
        return this.useTLS;
    }

    public StringPm getUser() {
        return this.user;
    }

    public StringPm getPassword() {
        return this.password;
    }

    public StringPm getHost() {
        return this.host;
    }

    public StringPm getPort() {
        return this.port;
    }

    public StringPm getSenderEmailAddress() {
        return this.senderEmailAdress;
    }
}

