/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.option.pm.moduleimp;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.ui.dialog.export.IColDesc;
import ch.transsoft.edec.util.Check;

public class ImpColDesc
implements IColDesc {
    private boolean editable;
    private boolean enabled;
    private int id;
    private final int label;

    public ImpColDesc(boolean enabled, boolean editable, int id, int label) {
        this.enabled = enabled;
        this.editable = editable;
        this.id = id;
        this.label = label;
    }

    @Override
    public String getId() {
        return Integer.toString(this.id);
    }

    public int getIntId() {
        return this.id;
    }

    @Override
    public boolean isEnabled() {
        if (!this.editable) {
            return true;
        }
        return this.enabled;
    }

    public void setEnabled(Object value) {
        this.enabled = (Boolean)value;
    }

    public boolean isCellEditable(int columnIndex) {
        if (columnIndex == 1) {
            return this.editable;
        }
        return false;
    }

    public Object getValueAt(int columnIndex, int cellIndex) {
        switch (columnIndex) {
            case 0: {
                return this.getCaption();
            }
            case 1: {
                return this.isEnabled();
            }
        }
        throw Check.fail("invalid columnIndex: " + columnIndex);
    }

    private Object getCaption() {
        return Services.getText(this.label);
    }

    public static String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Services.getText(4440);
            }
            case 1: {
                return Services.getText(4441);
            }
        }
        throw Check.fail("invalid columnIndex: " + columnIndex);
    }

    public static Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Boolean.class;
            }
        }
        throw Check.fail("invalid columnIndex: " + columnIndex);
    }

    public static int getColumnCount() {
        return 2;
    }
}

