/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.option.pm.moduleimp;

import ch.transsoft.edec.model.config.conf.options.ModuleImportInfo;
import ch.transsoft.edec.ui.dialog.option.pm.moduleimp.ImpColDescFactory;
import ch.transsoft.edec.ui.dialog.option.pm.moduleimp.ImpColTableModel;
import ch.transsoft.edec.ui.pm.model.BooleanPm;
import ch.transsoft.edec.ui.pm.model.IPm;
import ch.transsoft.edec.ui.pm.model.StringPm;
import ch.transsoft.edec.util.disposable.Disposables;
import ch.transsoft.edec.util.disposable.IDisposable;

public class OptionDialogModuleImportPm
implements IPm,
IDisposable {
    private Disposables disposables = new Disposables();
    private BooleanPm autoDownload;
    private BooleanPm downloadAfterStartup;
    private StringPm autoDownloadTime;
    private ImpColTableModel impColPm;
    private final ModuleImportInfo info;

    public OptionDialogModuleImportPm(ModuleImportInfo info) {
        this.info = info;
        this.autoDownload = new BooleanPm(info.getAutoDownload());
        this.downloadAfterStartup = new BooleanPm(info.getDownloadAfterStartup());
        this.autoDownloadTime = new StringPm(info.getDownloadTime());
        this.impColPm = new ImpColTableModel(ImpColDescFactory.getColDescs(info));
    }

    public BooleanPm getAutoDownload() {
        return this.autoDownload;
    }

    public BooleanPm getDownloadAfterStartup() {
        return this.downloadAfterStartup;
    }

    public StringPm getAutoDownloadTime() {
        return this.autoDownloadTime;
    }

    public ImpColTableModel getImpColPm() {
        return this.impColPm;
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }

    public void add(IDisposable disposable) {
        this.disposables.add(disposable);
    }

    public ModuleImportInfo getModuleImportInfo() {
        return this.info;
    }

    public void updateColDesc() {
        this.info.getColInfos().update(this.impColPm.getList());
    }
}

