/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.print.pm;

import ch.transsoft.edec.model.config.conf.printer.CorrectionData;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.model.sending.itemlist.ItemList;
import ch.transsoft.edec.service.form.IFormPageDesc;
import ch.transsoft.edec.service.form.render.IDataContext;
import ch.transsoft.edec.service.form.render.IRenderContext;
import ch.transsoft.edec.service.form.render.IUnitConverter;
import ch.transsoft.edec.service.form.render.RenderContext;
import ch.transsoft.edec.service.printer.PrintRenderer;
import ch.transsoft.edec.ui.dialog.print.pm.IPagePrintJob;
import ch.transsoft.edec.ui.gui.sending.forms.UnitConverterFactory;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import javax.print.attribute.standard.MediaSize;

public class PagePrintJob
implements IPagePrintJob {
    private static final int A4_WIDTH = (int)(MediaSize.ISO.A4.getX(25400) * 72.0f);
    private static final int A4_HEIGHT = (int)(MediaSize.ISO.A4.getY(25400) * 72.0f);
    private static final IUnitConverter CONVERTER = UnitConverterFactory.createPrintConverter();
    private final Sending sending;
    private final ItemList goodsItems;
    private final IDataContext dataContext;
    private final IFormPageDesc pageDesc;
    private final CorrectionData correction;
    private final IRenderContext.Mode mode;
    private final int copyNumber;

    public PagePrintJob(Sending sending, ItemList goodsItems, IFormPageDesc pageDesc, CorrectionData correction, IDataContext dataContext, IRenderContext.Mode mode, int copyNumber) {
        this.sending = sending;
        this.goodsItems = goodsItems;
        this.pageDesc = pageDesc;
        this.correction = correction;
        this.mode = mode;
        this.dataContext = dataContext;
        this.copyNumber = copyNumber;
    }

    @Override
    public void paint(Graphics g2) {
        Graphics2D g22 = (Graphics2D)g2.create();
        UnitConverterFactory.setRenderingHints(g22);
        g22.translate(CONVERTER.px(this.correction.getDx()), -CONVERTER.py(this.correction.getDy()));
        g22.setClip(new Rectangle2D.Double(0.0, 0.0, A4_WIDTH, A4_HEIGHT));
        PrintRenderer renderer = new PrintRenderer(this.sending, this.goodsItems, this.pageDesc, this.dataContext, CONVERTER, g22);
        this.pageDesc.render(this.sending, this.goodsItems, this.dataContext, new RenderContext(CONVERTER, g22, this.mode, this.copyNumber));
        renderer.render(g22);
    }
}

