/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.print.pm;

import ch.transsoft.edec.model.config.conf.printer.CorrectionData;
import ch.transsoft.edec.model.config.conf.printer.FormPrinterCorrection;
import ch.transsoft.edec.model.config.conf.printer.PrinterCorrection;
import ch.transsoft.edec.model.config.pref.printer.FormPagePrinterSelection;
import ch.transsoft.edec.model.config.pref.printer.FormPrinterSelection;
import ch.transsoft.edec.model.config.pref.printer.PrinterSelection;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.app.IAppService;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.form.IFormDesc;
import ch.transsoft.edec.service.form.IFormPageDesc;
import ch.transsoft.edec.service.form.IFormService;
import ch.transsoft.edec.service.form.PagePrintInfo;
import ch.transsoft.edec.ui.dialog.print.pm.PrintJob;
import ch.transsoft.edec.ui.dialog.print.pm.PrintJobPm;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;

public class PrintDialogPm {
    private final JButton printButton;
    private final List<PrintJobPm> printJobPms = new ArrayList<PrintJobPm>();
    private final Sending sending;
    private final PrinterSelection printerSelection;
    private boolean statePrinting = false;
    private PrintJob currentPrintJob;

    public PrintDialogPm(Sending sending, PrinterSelection printerSelection, PrinterCorrection correction) {
        this.sending = sending;
        this.printerSelection = printerSelection;
        this.printButton = new JButton(Services.getText(4504));
        this.printButton.setEnabled(this.hasForms());
        this.addPrintJobs(sending, correction);
        this.addPrintButtonListener();
    }

    private void addPrintJobs(Sending sending, PrinterCorrection correction) {
        FormPrinterCorrection formCorrection;
        FormPrinterSelection formSelection;
        for (IFormDesc form : this.getForms()) {
            if (!sending.getForms().isSelected(form)) continue;
            formSelection = this.printerSelection.getFormPrinterSelection(form.getId().name());
            formCorrection = correction.getFormPrinterCorrection(form.getId().name());
            IFormPageDesc frontPageDesc = form.getFrontPage(sending);
            PrintJobPm job = new PrintJobPm(form, sending);
            this.printJobPms.add(job);
            this.addFrontPageInfo(job, frontPageDesc, formSelection, formCorrection);
            if (!form.hasBackPage() || !formSelection.isDuplex()) continue;
            this.addBackPageInfo(job, form.getBackPage(), formSelection, formCorrection);
        }
        for (IFormDesc form : this.getForms()) {
            if (!sending.getForms().isSelected(form) || !form.hasBackPage()) continue;
            formSelection = this.printerSelection.getFormPrinterSelection(form.getId().name());
            formCorrection = correction.getFormPrinterCorrection(form.getId().name());
            if (!formSelection.isSimplex()) continue;
            PrintJobPm job = new PrintJobPm(form, sending);
            this.printJobPms.add(job);
            this.addBackPageInfo(job, form.getBackPage(), formSelection, formCorrection);
        }
    }

    private void addBackPageInfo(PrintJobPm job, IFormPageDesc backPageDesc, FormPrinterSelection formSelection, FormPrinterCorrection formCorrection) {
        FormPagePrinterSelection backPageSelection = formSelection.getBackPage();
        CorrectionData backPageCorrection = formCorrection.getBackPageCorrection().getCorrectionData(backPageSelection.getPrinterId().getValue());
        job.setBackPagePrintInfo(new PagePrintInfo(backPageDesc, backPageSelection, backPageCorrection));
    }

    private void addFrontPageInfo(PrintJobPm job, IFormPageDesc frontPageDesc, FormPrinterSelection formSelection, FormPrinterCorrection formCorrection) {
        FormPagePrinterSelection frontPageSelection = formSelection.getFrontPage();
        CorrectionData frontPageCorrection = formCorrection.getFrontPageCorrection().getCorrectionData(frontPageSelection.getPrinterId().getValue());
        job.setFrontPagePrintInfo(new PagePrintInfo(frontPageDesc, frontPageSelection, frontPageCorrection));
    }

    private void addPrintButtonListener() {
        this.printButton.addActionListener(e2 -> {
            this.print();
            this.savePrintCopies();
        });
    }

    public Iterable<PrintJobPm> getPrintJobPms() {
        return this.printJobPms;
    }

    private List<IFormDesc> getForms() {
        return Services.get(IFormService.class).getFormsInPrintOrder();
    }

    public void dispose() {
        if (this.currentPrintJob != null) {
            this.currentPrintJob.cancel(true);
        }
    }

    public void savePrintCopies() {
        for (PrintJobPm formPm : this.printJobPms) {
            formPm.savePrintCopies();
        }
        Services.get(IConfigService.class).savePrinterSelection(this.printerSelection);
    }

    public void print() {
        Services.get(IAppService.class).getCurrentSending().applyDefaults();
        if (this.statePrinting) {
            this.setStatePrinting(false);
            if (this.currentPrintJob != null) {
                this.currentPrintJob.cancel(true);
            }
            return;
        }
        this.setStatePrinting(true);
        this.startNextFormToPrint(this.printJobPms.get(0));
    }

    private boolean startNextFormToPrint(PrintJobPm printPagePm) {
        for (int i2 = this.printJobPms.indexOf(printPagePm); i2 < this.printJobPms.size(); ++i2) {
            PrintJobPm current = this.printJobPms.get(i2);
            if (!current.isSelected()) continue;
            this.currentPrintJob = new PrintJob(this, current);
            this.currentPrintJob.execute();
            return true;
        }
        this.setStatePrinting(false);
        return false;
    }

    private void setStatePrinting(boolean value) {
        this.printButton.setText(value ? Services.getText(4508) : Services.getText(4504));
        this.statePrinting = value;
        for (PrintJobPm formPm : this.printJobPms) {
            formPm.setStatePrinting(value);
        }
    }

    public void printComplete(PrintJobPm printPagePm) {
        this.currentPrintJob = null;
        if (!this.statePrinting) {
            return;
        }
        if (this.startNextFormToPrint(printPagePm)) {
            return;
        }
        this.selectNextJobs(printPagePm);
    }

    private void selectNextJobs(PrintJobPm printPagePm) {
        int index = this.printJobPms.indexOf(printPagePm);
        if (index == this.printJobPms.size() - 1) {
            return;
        }
        for (int i2 = index + 1; i2 < this.printJobPms.size(); ++i2) {
            this.printJobPms.get(i2).setSelected();
        }
    }

    public boolean hasForms() {
        return this.sending.getForms().hasSelectedForm();
    }

    public JButton getPrintButton() {
        return this.printButton;
    }
}

