/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.print.pm;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.service.printer.IPrinterService;
import ch.transsoft.edec.service.printer.Printer;
import ch.transsoft.edec.service.printer.hack.ForcedAcceptPrintService;
import ch.transsoft.edec.ui.dialog.print.pm.IPagePrintJob;
import ch.transsoft.edec.ui.dialog.print.pm.PrintDialogPm;
import ch.transsoft.edec.ui.dialog.print.pm.PrintJobPm;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.Sides;
import javax.swing.SwingWorker;

public class PrintJob
extends SwingWorker<Void, Integer>
implements Printable {
    private final PrintDialogPm printPm;
    private final PrintJobPm printPagePm;
    private final List<IPagePrintJob> pagePrintJobs = new ArrayList<IPagePrintJob>();

    public PrintJob(PrintDialogPm printPm, PrintJobPm printPagePm) {
        this.printPm = printPm;
        this.printPagePm = printPagePm;
    }

    @Override
    protected Void doInBackground() throws Exception {
        List<IPagePrintJob> jobs = this.printPagePm.getPagePrintJobs();
        for (int i2 = 0; i2 < this.printPagePm.getNumberOfCopies(); ++i2) {
            this.pagePrintJobs.addAll(jobs);
        }
        this.startPrinting();
        return null;
    }

    private void startPrinting() throws PrinterException {
        Printer printer = this.getPrinter();
        MediaTray tray = printer.getMediaTray(this.printPagePm.getMediaTray());
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        aset.add(MediaSizeName.ISO_A4);
        if (tray != null) {
            aset.add(tray);
        }
        if (this.printPagePm.isDuplex()) {
            aset.add(Sides.DUPLEX);
        }
        try {
            PrinterJob job = PrinterJob.getPrinterJob();
            job.setPrintService(printer.getPrintService());
            this.print(aset, job);
        }
        catch (PrinterException pe) {
            if (pe.getMessage() != null && !pe.getMessage().contains("accepting job")) {
                throw pe;
            }
            PrinterJob job = PrinterJob.getPrinterJob();
            job.setPrintService(new ForcedAcceptPrintService(printer.getPrintService()));
            this.print(aset, job);
        }
    }

    private void print(PrintRequestAttributeSet aset, PrinterJob job) throws PrinterException {
        job.setJobName("ExpoVit " + this.printPagePm.getFormName());
        job.setPrintable(this);
        job.print(aset);
    }

    private Printer getPrinter() {
        return Services.get(IPrinterService.class).getPrinter(this.printPagePm.getPrinterId());
    }

    @Override
    protected void done() {
        Throwable error = null;
        try {
            this.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException e2) {
            error = e2.getCause();
        }
        catch (CancellationException e3) {
            error = new RuntimeException(Services.getText(4509));
        }
        if (error != null) {
            Services.get(ILoggingService.class).logSilent(error, "error during printing");
        }
        this.printPagePm.printComplete(error);
        this.printPm.printComplete(this.printPagePm);
    }

    @Override
    protected void process(List<Integer> chunks) {
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (this.isCancelled()) {
            return 1;
        }
        if (pageIndex >= this.pagePrintJobs.size()) {
            return 1;
        }
        this.publish(pageIndex + 1);
        this.pagePrintJobs.get(pageIndex).paint(graphics);
        return 0;
    }
}

