/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.print.pm;

import ch.transsoft.edec.model.config.pref.printer.FormPagePrinterSelection;
import ch.transsoft.edec.model.infra.node.IntegralNode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.form.IFormDesc;
import ch.transsoft.edec.service.form.IFormPageDesc;
import ch.transsoft.edec.service.form.PagePrintInfo;
import ch.transsoft.edec.service.form.render.DataContext;
import ch.transsoft.edec.service.form.render.IRenderContext;
import ch.transsoft.edec.ui.dialog.print.pm.IPagePrintJob;
import ch.transsoft.edec.ui.gui.control.icondisplay.IconDisplayModel;
import ch.transsoft.edec.ui.gui.control.textfield.SimpleDocument;
import ch.transsoft.edec.util.Check;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PrintJobPm {
    private final IFormDesc form;
    private PagePrintInfo frontPagePrintInfo;
    private PagePrintInfo backPagePrintInfo;
    private final JToggleButton.ToggleButtonModel printModel = new JToggleButton.ToggleButtonModel();
    private final SimpleDocument numberModel = new SimpleDocument();
    private int numberOfCopies = 0;
    private final SimpleDocument numberOfUnitsModel = new SimpleDocument();
    private final IconDisplayModel batchIconModel = new IconDisplayModel();
    private final IconDisplayModel arrowIconModel = new IconDisplayModel();
    private final Sending sending;
    private final DataContext dataContext;

    public PrintJobPm(IFormDesc form, Sending sending) {
        this.form = form;
        this.sending = sending;
        this.dataContext = form.createDataContext(sending);
        this.addPrintModelListener();
        this.addNumberModelListener();
    }

    private void addPrintModelListener() {
        this.printModel.addActionListener(e2 -> this.updateArrow());
    }

    private void addNumberModelListener() {
        this.numberModel.addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e2) {
                PrintJobPm.this.numberChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e2) {
                PrintJobPm.this.numberChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e2) {
            }
        });
    }

    private void numberChanged() {
        try {
            long value = Integer.parseInt(this.numberModel.getText());
            if (value < 0L) {
                return;
            }
            this.numberOfCopies = (int)value;
            this.numberOfUnitsModel.setText(this.getUnitLabel());
            this.updateArrow();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public PagePrintInfo getFormPrintInfo() {
        if (this.frontPagePrintInfo != null) {
            return this.frontPagePrintInfo;
        }
        Check.assertNotNull(this.backPagePrintInfo);
        return this.backPagePrintInfo;
    }

    public void setFrontPagePrintInfo(PagePrintInfo info) {
        this.frontPagePrintInfo = info;
        this.printModel.setSelected(true);
        this.initState();
    }

    public void setBackPagePrintInfo(PagePrintInfo info) {
        this.backPagePrintInfo = info;
        this.initState();
    }

    private void initState() {
        this.batchIconModel.setIcon(this.getFormPageDesc().getIcon());
        int copies = this.getPrintCopies().isInitialized() ? this.getPrintCopies().getIntValue() : this.form.getDefaultNumber();
        this.numberModel.setText(Integer.toString(copies));
        this.updateArrow();
    }

    private void updateArrow() {
        if (this.printModel.isSelected() && this.getNumberOfUnits() > 0) {
            this.arrowIconModel.setIcon("icon/Red-Arrow-32x32.png");
        } else {
            this.arrowIconModel.removeIcon();
        }
    }

    public ImageIcon getIcon() {
        return this.getFormPageDesc().getIcon();
    }

    public IFormPageDesc getFormPageDesc() {
        return this.getFormPrintInfo().getPageDesc();
    }

    public String getFormName() {
        return this.isDuplex() ? this.form.getDuplexName() : this.getFormPageDesc().getPrintName();
    }

    public boolean isDuplex() {
        return this.frontPagePrintInfo != null && this.backPagePrintInfo != null;
    }

    public JToggleButton.ToggleButtonModel getPrintModel() {
        return this.printModel;
    }

    public SimpleDocument getNumberModel() {
        return this.numberModel;
    }

    public String getPrinter() {
        return this.getSelection().getPrinterId().getValue();
    }

    private IntegralNode getPrintCopies() {
        return this.getSelection().getPrintCopies();
    }

    public void savePrintCopies() {
        this.getSelection().setPrintCopies(this.numberOfCopies);
    }

    private FormPagePrinterSelection getSelection() {
        return this.getFormPrintInfo().getPrinterSelection();
    }

    public String getUnitLabel() {
        int units = this.getNumberOfUnits();
        return units + " " + this.getUnitName(units);
    }

    public int getNumberOfUnits() {
        return this.form.getNumberOfUnits(this.getNumberOfCopies(), this.sending, this.dataContext);
    }

    public int getNumberOfCopies() {
        return this.numberOfCopies;
    }

    private String getUnitName(int units) {
        return this.getFormPageDesc().getUnitName(units);
    }

    public SimpleDocument getNumberOfUnitsModel() {
        return this.numberOfUnitsModel;
    }

    public List<IPagePrintJob> getPagePrintJobs() {
        return this.isDuplex() ? this.getDuplexPrintJobs() : this.getSimplexPrintJobs();
    }

    private List<IPagePrintJob> getDuplexPrintJobs() {
        return this.form.printDuplex(this.sending, this.dataContext, this.frontPagePrintInfo, this.backPagePrintInfo, IRenderContext.Mode.printer);
    }

    private List<IPagePrintJob> getSimplexPrintJobs() {
        PagePrintInfo printInfo = this.getFormPrintInfo();
        return this.form.printSimplex(this.sending, this.dataContext, printInfo, IRenderContext.Mode.printer);
    }

    public IconDisplayModel getBatchIconModel() {
        return this.batchIconModel;
    }

    public IconDisplayModel getArrowIconModel() {
        return this.arrowIconModel;
    }

    public void printComplete(Throwable error) {
        this.printModel.setSelected(false);
        if (error == null) {
            this.arrowIconModel.setIcon("icon/Check-green-32x32.png");
        } else {
            this.arrowIconModel.setIcon("icon/Cancel-32x32.png");
            this.arrowIconModel.setToolTip(error.getMessage());
        }
    }

    public void setStatePrinting(boolean value) {
        this.printModel.setEnabled(!value);
        this.numberModel.setEnable(!value);
    }

    public boolean isSelected() {
        return this.printModel.isSelected();
    }

    public void setSelected() {
        this.printModel.setSelected(true);
        this.updateArrow();
    }

    public String getPrinterId() {
        return this.getSelection().getPrinterId().getValue();
    }

    public int getMediaTray() {
        return this.getSelection().getMediaTray().getIntValue();
    }
}

