/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.printerconfig.gui;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.ui.dialog.printerconfig.gui.PrinterCorrectionHeadPanel;
import ch.transsoft.edec.ui.dialog.printerconfig.pm.FormConfigPm;
import ch.transsoft.edec.ui.dialog.printerconfig.pm.FormPageConfigPm;
import ch.transsoft.edec.ui.dialog.printerconfig.pm.PrinterConfigPm;
import ch.transsoft.edec.ui.gui.control.DefaultPanel;
import ch.transsoft.edec.ui.gui.control.Label;
import ch.transsoft.edec.ui.gui.control.LabelField;
import ch.transsoft.edec.ui.gui.control.icondisplay.IconDisplay;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

public class PrinterCorrectionPanel
extends DefaultPanel {
    private final PrinterConfigPm pm;

    public PrinterCorrectionPanel(PrinterConfigPm pm) {
        this.pm = pm;
        this.setLayout(new BorderLayout());
        this.add((Component)new PrinterCorrectionHeadPanel(), "North");
        this.add((Component)new JScrollPane(this.createContent()), "Center");
    }

    private JComponent createContent() {
        DefaultPanel contentPanel = new DefaultPanel();
        contentPanel.setLayout(new MigLayout("", "[][]20[][]20[][]20[200,fill]", ""));
        contentPanel.add((Component)new Label(Services.getText(4604), true), "span 2");
        contentPanel.add((Component)new Label(Services.getText(4605), true), "span 2");
        contentPanel.add((Component)new Label(Services.getText(4606), true), "span 2");
        contentPanel.add((Component)new Label(Services.getText(4607), true), "wrap");
        for (FormConfigPm formConfigPm : this.pm.getFormConfigPms()) {
            this.createContent(contentPanel, formConfigPm);
        }
        return contentPanel;
    }

    private void createContent(DefaultPanel contentPanel, FormConfigPm pm) {
        FormPageConfigPm front = pm.getFrontPm();
        FormPageConfigPm back = pm.getBackPm();
        String nameFront = null;
        String nameBack = null;
        if (back == null) {
            nameFront = front.getPrintName();
        } else {
            nameFront = front.getPrintName();
            nameBack = back.getPrintName();
        }
        this.addFormPageControls(contentPanel, front, nameFront);
        if (back == null) {
            return;
        }
        this.addFormPageControls(contentPanel, back, nameBack);
    }

    private void addFormPageControls(DefaultPanel contentPanel, FormPageConfigPm pagePm, String name) {
        IconDisplay iconDisplay = new IconDisplay(pagePm.getIcon());
        contentPanel.add((Component)iconDisplay, "width 40!, height 40!");
        contentPanel.add(new Label(name));
        JTextField fieldx = new JTextField();
        fieldx.setDocument(pagePm.getDx());
        contentPanel.add((Component)fieldx, "width 60!");
        contentPanel.add(new JLabel("mm"));
        JTextField fieldy = new JTextField();
        fieldy.setDocument(pagePm.getDy());
        contentPanel.add((Component)fieldy, "width 60!");
        contentPanel.add((Component)new JLabel("mm"), "");
        contentPanel.add((Component)new LabelField(pagePm.getSelectedPrinterName(), false), "wrap");
    }
}

