/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.printerconfig.pm;

import ch.transsoft.edec.model.config.conf.printer.FormPagePrinterCorrection;
import ch.transsoft.edec.model.config.conf.printer.FormPrinterCorrection;
import ch.transsoft.edec.model.config.pref.printer.FormPagePrinterSelection;
import ch.transsoft.edec.model.config.pref.printer.FormPrinterSelection;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.app.IAppService;
import ch.transsoft.edec.service.form.IFormDesc;
import ch.transsoft.edec.service.form.IFormPageDesc;
import ch.transsoft.edec.service.printer.Printer;
import ch.transsoft.edec.service.printer.PrinterList;
import ch.transsoft.edec.ui.dialog.printerconfig.pm.FormPageConfigPm;
import javax.swing.ButtonModel;
import javax.swing.JToggleButton;

public class FormConfigPm {
    private final FormPrinterSelection formPrinterSelection;
    private final JToggleButton.ToggleButtonModel duplexButtonPm = new JToggleButton.ToggleButtonModel();
    private final FormPageConfigPm frontPm;
    private FormPageConfigPm backPm;

    public FormConfigPm(IFormDesc form, FormPrinterSelection formPrinterSelection, FormPrinterCorrection correction) {
        this.formPrinterSelection = formPrinterSelection;
        this.duplexButtonPm.setSelected(formPrinterSelection.getDuplex().getValue());
        Sending sending = Services.get(IAppService.class).getCurrentSending();
        FormPagePrinterSelection frontPageSelection = formPrinterSelection.getFrontPage();
        FormPagePrinterCorrection frontPageCorrection = correction.getFrontPageCorrection();
        this.frontPm = new FormPageConfigPm(this.duplexButtonPm, formPrinterSelection, form.getFrontPage(sending), frontPageSelection, frontPageCorrection);
        IFormPageDesc backPage = form.getBackPage();
        if (backPage != null) {
            FormPagePrinterSelection backPageSelection = formPrinterSelection.getBackPage();
            FormPagePrinterCorrection backPageCorrection = correction.getBackPageCorrection();
            this.backPm = new FormPageConfigPm(formPrinterSelection, backPage, backPageSelection, backPageCorrection);
            this.backPm.initComboStates(formPrinterSelection.getDuplex().getValue());
        }
        this.addDuplexListener();
        this.addPrinterModelListener();
    }

    private Printer getSelectedPrinter(FormPageConfigPm pm) {
        return (Printer)pm.getPrinterModel().getSelectedItem();
    }

    private void addDuplexListener() {
        this.duplexButtonPm.addActionListener(e2 -> {
            this.formPrinterSelection.setDuplex(this.duplexButtonPm.isSelected());
            this.backPm.getPrinterModel().setEnabled(!this.duplexButtonPm.isSelected());
            this.backPm.getTrayModel().setEnabled(!this.duplexButtonPm.isSelected());
        });
    }

    private void addPrinterModelListener() {
        this.frontPm.getPrinterModel().addSelectionChangeListener(() -> {
            if (!this.hasBackPage()) {
                return;
            }
            Printer selectedPrinter = this.getSelectedPrinter(this.frontPm);
            if (selectedPrinter == null) {
                return;
            }
            if (!selectedPrinter.isSupportsDuplex()) {
                this.backPm.getTrayModel().setEnabled(true);
                this.backPm.getPrinterModel().setEnabled(true);
            }
        });
    }

    public boolean hasBackPage() {
        return this.backPm != null;
    }

    public FormPageConfigPm getFrontPm() {
        return this.frontPm;
    }

    public FormPageConfigPm getBackPm() {
        return this.backPm;
    }

    public ButtonModel getDuplexModel() {
        return this.duplexButtonPm;
    }

    public void addPrinters(PrinterList printers) {
        this.frontPm.addPrinters(printers);
        if (this.hasBackPage()) {
            this.backPm.addPrinters(printers);
        }
    }
}

