/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.printerconfig.pm;

import ch.transsoft.edec.model.config.conf.printer.CorrectionData;
import ch.transsoft.edec.model.config.conf.printer.FormPagePrinterCorrection;
import ch.transsoft.edec.model.config.pref.printer.FormPagePrinterSelection;
import ch.transsoft.edec.model.config.pref.printer.FormPrinterSelection;
import ch.transsoft.edec.service.form.IFormPageDesc;
import ch.transsoft.edec.service.printer.Printer;
import ch.transsoft.edec.service.printer.PrinterList;
import ch.transsoft.edec.ui.dialog.printerconfig.pm.DefaultTray;
import ch.transsoft.edec.ui.gui.control.combo.StateAwareComboBoxModel;
import ch.transsoft.edec.ui.gui.control.textfield.SimpleDocument;
import javax.print.attribute.standard.MediaTray;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.PlainDocument;

public class FormPageConfigPm {
    private final FormPagePrinterSelection selection;
    private final FormPagePrinterCorrection correction;
    private final FormPrinterSelection formPrinterSelection;
    private final StateAwareComboBoxModel<Printer> printerModel = new StateAwareComboBoxModel();
    private final StateAwareComboBoxModel<MediaTray> trayModel = new StateAwareComboBoxModel();
    private final SimpleDocument dx = new SimpleDocument();
    private final SimpleDocument dy = new SimpleDocument();
    private final SimpleDocument selectedPrinterName = new SimpleDocument();
    private final IFormPageDesc formPageDesc;
    private final JToggleButton.ToggleButtonModel duplexPm;

    public FormPageConfigPm(FormPrinterSelection formPrinterSelection, IFormPageDesc formPageDesc, FormPagePrinterSelection selection, FormPagePrinterCorrection correction) {
        this(null, formPrinterSelection, formPageDesc, selection, correction);
    }

    public FormPageConfigPm(JToggleButton.ToggleButtonModel duplexPm, FormPrinterSelection formPrinterSelection, IFormPageDesc formPageDesc, FormPagePrinterSelection selection, FormPagePrinterCorrection correction) {
        this.duplexPm = duplexPm;
        this.formPrinterSelection = formPrinterSelection;
        this.formPageDesc = formPageDesc;
        this.selection = selection;
        this.correction = correction;
        this.updateCorrectionGui();
        this.addDocumentListeners();
    }

    private void updateCorrectionGui() {
        CorrectionData correctionData = this.getCorrectionData();
        this.dx.setText(correctionData.getDx().toString());
        this.dy.setText(correctionData.getDy().toString());
        this.selectedPrinterName.setText(this.selection.getPrinterId().getValue());
    }

    private CorrectionData getCorrectionData() {
        return this.correction.getCorrectionData(this.selection.getPrinterId().getValue());
    }

    private void addDocumentListeners() {
        this.dx.addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e2) {
                FormPageConfigPm.this.updateX();
            }

            @Override
            public void insertUpdate(DocumentEvent e2) {
                FormPageConfigPm.this.updateX();
            }

            @Override
            public void changedUpdate(DocumentEvent e2) {
            }
        });
        this.dy.addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e2) {
                FormPageConfigPm.this.updateY();
            }

            @Override
            public void insertUpdate(DocumentEvent e2) {
                FormPageConfigPm.this.updateY();
            }

            @Override
            public void changedUpdate(DocumentEvent e2) {
            }
        });
    }

    private void updateX() {
        try {
            double value = Double.parseDouble(this.dx.getText());
            this.getCorrectionData().getDx().setValue(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void updateY() {
        try {
            double value = Double.parseDouble(this.dy.getText());
            this.getCorrectionData().getDy().setValue(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void addTrayModelListener() {
        this.trayModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e2) {
            }

            @Override
            public void intervalAdded(ListDataEvent e2) {
            }

            @Override
            public void contentsChanged(ListDataEvent e2) {
                FormPageConfigPm.this.trayChanged();
            }
        });
    }

    private void trayChanged() {
        MediaTray selectedItem = (MediaTray)this.trayModel.getSelectedItem();
        this.selection.setMediaTray(selectedItem.getValue());
    }

    private void addPrinterModelListener() {
        this.printerModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e2) {
            }

            @Override
            public void intervalAdded(ListDataEvent e2) {
            }

            @Override
            public void contentsChanged(ListDataEvent e2) {
                FormPageConfigPm.this.printerChanged();
            }
        });
    }

    private void printerChanged() {
        this.initNewPrinter();
        Printer selectedPrinter = this.getSelectedPrinter();
        this.selection.setPrinterId(selectedPrinter.getId());
        this.updateCorrectionGui();
    }

    private void initNewPrinter() {
        this.trayModel.removeAllElements();
        this.trayModel.addElement(new DefaultTray());
        for (MediaTray current : this.getSelectedPrinter().getMediaTrays()) {
            this.trayModel.addElement(current);
        }
        if (this.duplexPm != null) {
            this.duplexPm.setEnabled(this.getSelectedPrinter().isSupportsDuplex());
            if (!this.getSelectedPrinter().isSupportsDuplex()) {
                this.duplexPm.setSelected(false);
                this.formPrinterSelection.setDuplex(false);
            }
        }
    }

    private Printer getSelectedPrinter() {
        return (Printer)this.printerModel.getSelectedItem();
    }

    public ImageIcon getIcon() {
        return this.formPageDesc.getIcon();
    }

    public String getGuiName() {
        return this.formPageDesc.getGuiName();
    }

    public String getPrintName() {
        return this.formPageDesc.getPrintName();
    }

    public StateAwareComboBoxModel<Printer> getPrinterModel() {
        return this.printerModel;
    }

    public StateAwareComboBoxModel<MediaTray> getTrayModel() {
        return this.trayModel;
    }

    public void addPrinters(PrinterList printers) {
        for (Printer current : printers) {
            this.printerModel.addElement(current);
        }
        this.selectPrinter(printers);
        this.selectTray();
        this.addPrinterModelListener();
        this.addTrayModelListener();
    }

    private void selectTray() {
        for (MediaTray tray : this.getSelectedPrinter().getMediaTrays()) {
            if (this.selection.getMediaTray().getIntValue() != tray.getValue()) continue;
            this.trayModel.setSelectedItem(tray);
        }
    }

    private void selectPrinter(PrinterList printers) {
        for (Printer current : printers) {
            if (!this.selection.getPrinterId().getValue().equals(current.getId())) continue;
            this.printerModel.setSelectedItem(current);
            this.initNewPrinter();
            return;
        }
        this.printerModel.setSelectedItem(printers.get(0));
        this.printerChanged();
    }

    public PlainDocument getDx() {
        return this.dx;
    }

    public PlainDocument getDy() {
        return this.dy;
    }

    public PlainDocument getSelectedPrinterName() {
        return this.selectedPrinterName;
    }

    public void initComboStates(boolean duplexSelection) {
        this.printerModel.setEnabled(!duplexSelection);
        this.trayModel.setEnabled(!duplexSelection);
    }
}

