/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.printerconfig.pm;

import ch.transsoft.edec.model.config.conf.printer.FormPrinterCorrection;
import ch.transsoft.edec.model.config.conf.printer.PrintNameCorrection;
import ch.transsoft.edec.model.config.conf.printer.PrinterCorrection;
import ch.transsoft.edec.model.config.pref.printer.FormPrinterSelection;
import ch.transsoft.edec.model.config.pref.printer.PrinterSelection;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.form.IFormDesc;
import ch.transsoft.edec.service.form.IFormService;
import ch.transsoft.edec.service.printer.IPrinterHandler;
import ch.transsoft.edec.service.printer.IPrinterService;
import ch.transsoft.edec.service.printer.Printer;
import ch.transsoft.edec.service.printer.PrinterFetcher;
import ch.transsoft.edec.service.printer.PrinterList;
import ch.transsoft.edec.ui.dialog.printerconfig.pm.FormConfigPm;
import ch.transsoft.edec.ui.dialog.printerconfig.pm.IPrinterConfigListener;
import ch.transsoft.edec.ui.dialog.printerconfig.pm.PrinterNameCorrectionPm;
import ch.transsoft.edec.util.disposable.IDisposable;
import ch.transsoft.edec.util.disposable.ListenerList;
import java.util.ArrayList;
import java.util.List;

public class PrinterConfigPm
implements IPrinterHandler {
    private final PrinterSelection printerSelection;
    private final PrinterCorrection printerCorrection;
    private final PrintNameCorrection printNameCorrection;
    private final List<FormConfigPm> formConfigPms = new ArrayList<FormConfigPm>();
    private final ListenerList<IPrinterConfigListener> listeners = new ListenerList();
    private final PrinterNameCorrectionPm printerNameCorrectionPm;

    public PrinterConfigPm(PrinterSelection printerSelection, PrinterCorrection printerCorrection, PrintNameCorrection printNameCorrection) {
        this.printerSelection = printerSelection;
        this.printerCorrection = printerCorrection;
        this.printNameCorrection = printNameCorrection;
        this.printerNameCorrectionPm = new PrinterNameCorrectionPm(printNameCorrection);
        for (IFormDesc form : Services.get(IFormService.class).getForms()) {
            this.createFormConfigPm(form);
        }
        new PrinterFetcher(Services.get(IPrinterService.class), this).execute();
    }

    private void createFormConfigPm(IFormDesc form) {
        FormPrinterSelection selection = this.printerSelection.getFormPrinterSelection(form.getId().name());
        FormPrinterCorrection correction = this.printerCorrection.getFormPrinterCorrection(form.getId().name());
        this.formConfigPms.add(new FormConfigPm(form, selection, correction));
    }

    public PrinterSelection getPrinterConfig() {
        return this.printerSelection;
    }

    public Iterable<FormConfigPm> getFormConfigPms() {
        return this.formConfigPms;
    }

    public PrinterNameCorrectionPm getPrinterNameCorrectionPm() {
        return this.printerNameCorrectionPm;
    }

    public void dispose() {
    }

    @Override
    public void finish(PrinterList printers) {
        for (IPrinterConfigListener listener : this.listeners) {
            listener.finish();
        }
        if (printers == null || printers.isEmpty()) {
            return;
        }
        for (FormConfigPm current : this.formConfigPms) {
            current.addPrinters(printers);
        }
    }

    @Override
    public void next(Printer printer) {
        for (IPrinterConfigListener listener : this.listeners) {
            listener.next(printer);
        }
    }

    public IDisposable addListener(IPrinterConfigListener listener) {
        return this.listeners.add(listener);
    }

    public void save() {
        Services.get(IConfigService.class).savePrinterSelection(this.printerSelection);
        Services.get(IConfigService.class).savePrinterCorrection(this.printerCorrection);
        Services.get(IConfigService.class).savePrintNameCorrection(this.printNameCorrection);
    }
}

