/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.refund.voc.pm;

import ch.transsoft.edec.ui.dialog.refund.voc.pm.EvvDocWrapper;
import ch.transsoft.edec.ui.dialog.refund.voc.pm.EvvItemWrapper;
import ch.transsoft.edec.ui.dialog.refund.voc.pm.RefundItemHandle;
import ch.transsoft.edec.util.Check;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class RefundSendingHandle {
    private Date date;
    private String customsDeclarationNumber;
    private List<RefundItemHandle> items = new ArrayList<RefundItemHandle>();

    public RefundSendingHandle(EvvDocWrapper evvDocWrapper, Date date) throws Exception {
        Check.assertNotNull(date);
        this.date = date;
        this.customsDeclarationNumber = evvDocWrapper.getDocumentNumberAndVersion();
        for (EvvItemWrapper item : evvDocWrapper.getItems()) {
            RefundItemHandle refundItem = new RefundItemHandle(this, item);
            if (!refundItem.hasVOC(refundItem)) continue;
            this.items.add(refundItem);
        }
    }

    public Date getDate() {
        return this.date;
    }

    public String getCustomsDeclarationNumber() {
        return this.customsDeclarationNumber;
    }

    public List<RefundItemHandle> getItems() {
        return this.items;
    }

    public boolean hasActiveItems() {
        for (RefundItemHandle item : this.getItems()) {
            if (!item.getIncluded().booleanValue()) continue;
            return true;
        }
        return false;
    }
}

