/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.trust.gui;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.gui.IGuiService;
import ch.transsoft.edec.ui.dialog.trust.pm.CertificateModel;
import ch.transsoft.edec.ui.dialog.trust.pm.ImportCertificatePm;
import ch.transsoft.edec.util.ui.LabelModel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;

public class ImportCertificateDialog {
    private final JDialog window = new JDialog((Window)Services.get(IGuiService.class).getMainFrame(), "Title", Dialog.ModalityType.APPLICATION_MODAL);

    public static boolean showCertificateImportDialog(List<X509Certificate> chain) {
        AtomicBoolean shouldImport = new AtomicBoolean(false);
        if (SwingUtilities.isEventDispatchThread()) {
            shouldImport.set(ImportCertificateDialog.show(chain));
        } else {
            try {
                SwingUtilities.invokeAndWait(() -> shouldImport.set(ImportCertificateDialog.show(chain)));
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
        return shouldImport.get();
    }

    public static boolean show(List<X509Certificate> chain) {
        ImportCertificatePm pm = new ImportCertificatePm(chain.stream().map(CertificateModel::fromCertificate).collect(Collectors.toList()));
        ImportCertificateDialog modal = new ImportCertificateDialog(pm);
        pm.setCloseWindowListener(modal::close);
        modal.show();
        return pm.shouldImport;
    }

    private ImportCertificateDialog(ImportCertificatePm pm) {
        this.window.setSize(350, 500);
        this.window.setTitle(Services.getText(100423));
        this.window.getContentPane().setLayout(new MigLayout("ins dialog, fill, wrap 2", "", ""));
        JList<CertificateModel> list = new JList<CertificateModel>(pm.getCertificates());
        list.addListSelectionListener(e2 -> pm.certificateSelectionChanged((CertificateModel)list.getSelectedValue()));
        list.setSelectedValue(pm.getSelected(), true);
        this.window.getContentPane().add((Component)new JScrollPane(list), "span, grow, push");
        this.window.getContentPane().add((Component)new JLabel("<html><h3>" + Services.getText(100421) + "</h3></html>"), "gaptop 0, span");
        this.window.getContentPane().add((Component)new JLabel(Services.getText(100415)), "");
        this.window.getContentPane().add((Component)this.newLabelFromModel(pm.getSubjectCN()), "wrap");
        this.window.getContentPane().add((Component)new JLabel(Services.getText(100416)), "");
        this.window.getContentPane().add((Component)this.newLabelFromModel(pm.getSubjectC()), "");
        this.window.getContentPane().add((Component)new JLabel(Services.getText(100417)), "");
        this.window.getContentPane().add((Component)this.newLabelFromModel(pm.getSubjectO()), "");
        this.window.getContentPane().add((Component)new JLabel("<html><h3>" + Services.getText(100422) + "</h3></html>"), "gaptop 0, span");
        this.window.getContentPane().add((Component)new JLabel(Services.getText(100415)), "");
        this.window.getContentPane().add((Component)this.newLabelFromModel(pm.getIssuerCN()), "");
        this.window.getContentPane().add((Component)new JLabel(Services.getText(100416)), "");
        this.window.getContentPane().add((Component)this.newLabelFromModel(pm.getIssuerC()), "");
        this.window.getContentPane().add((Component)new JLabel(Services.getText(100417)), "");
        this.window.getContentPane().add((Component)this.newLabelFromModel(pm.getIssuerO()), "");
        this.window.getContentPane().add((Component)new JLabel("<html><h3>" + Services.getText(100420) + "</h3></html>"), "span");
        this.window.getContentPane().add((Component)new JLabel(Services.getText(100418)), "");
        this.window.getContentPane().add((Component)this.newLabelFromModel(pm.getValidFromModel()), "");
        this.window.getContentPane().add((Component)new JLabel(Services.getText(100419)), "");
        this.window.getContentPane().add((Component)this.newLabelFromModel(pm.getValidUntilModel()), "");
        this.window.getContentPane().add((Component)new JButton(pm.getOkAction()), "span, align right, split 2, tag ok, sg button");
        this.window.getContentPane().add((Component)new JButton(pm.getCancelAction()), "tag cancel, sg button");
        this.window.setLocationRelativeTo(null);
    }

    public void show() {
        this.window.setVisible(true);
    }

    private void close() {
        this.window.setVisible(false);
    }

    private JLabel newLabelFromModel(LabelModel model) {
        JLabel label = new JLabel();
        model.setLabel(label);
        return label;
    }
}

