/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.trust.pm;

import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class CertificateInfo {
    private final ParsedPrincipal subject;
    private final ParsedPrincipal issuer;
    private final Date validFrom;
    private final Date validUntil;
    private final String serialNumber;
    private final String sha256Fingerprint;
    private final String sha1Fingerprint;
    private final boolean isExpired;
    private final boolean isNotYetValid;

    public CertificateInfo(ParsedPrincipal subject, ParsedPrincipal issuer, Date validFrom, Date validUntil, String serialNumber, String sha256Fingerprint, String sha1Fingerprint, boolean isExpired, boolean isNotYetValid) {
        this.subject = subject;
        this.issuer = issuer;
        this.validFrom = validFrom;
        this.validUntil = validUntil;
        this.serialNumber = serialNumber;
        this.sha256Fingerprint = sha256Fingerprint;
        this.sha1Fingerprint = sha1Fingerprint;
        this.isExpired = isExpired;
        this.isNotYetValid = isNotYetValid;
    }

    public ParsedPrincipal subject() {
        return this.subject;
    }

    public ParsedPrincipal issuer() {
        return this.issuer;
    }

    public Date validFrom() {
        return this.validFrom;
    }

    public Date validUntil() {
        return this.validUntil;
    }

    public String serialNumber() {
        return this.serialNumber;
    }

    public String sha256Fingerprint() {
        return this.sha256Fingerprint;
    }

    public String sha1Fingerprint() {
        return this.sha1Fingerprint;
    }

    public boolean isExpired() {
        return this.isExpired;
    }

    public boolean isNotYetValid() {
        return this.isNotYetValid;
    }

    public static CertificateInfo fromCertificate(X509Certificate certificate) {
        return new CertificateInfo(ParsedPrincipal.parse(certificate.getSubjectX500Principal().getName()), ParsedPrincipal.parse(certificate.getIssuerX500Principal().getName()), certificate.getNotBefore(), certificate.getNotAfter(), certificate.getSerialNumber().toString(16).toUpperCase(), CertificateInfo.getFingerprint(certificate, "SHA-256"), CertificateInfo.getFingerprint(certificate, "SHA-1"), certificate.getNotAfter().before(new Date()), certificate.getNotBefore().after(new Date()));
    }

    private static String getFingerprint(X509Certificate certificate, String algorithm) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            byte[] fingerprint = digest.digest(certificate.getEncoded());
            StringBuilder builder = new StringBuilder();
            for (int i2 = 0; i2 < fingerprint.length; ++i2) {
                builder.append(String.format("%02x", fingerprint[i2]));
                if (i2 >= fingerprint.length - 1) continue;
                builder.append(":");
            }
            return builder.toString();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public static class ParsedPrincipal {
        private static final String CN = "CN=";
        private static final String O = "O=";
        private static final String C = "C=";
        private String commonName;
        private String organisation;
        private String country;

        public ParsedPrincipal(String commonName, String organisation, String country) {
            this.commonName = commonName;
            this.organisation = organisation;
            this.country = country;
        }

        public String commonName() {
            return this.commonName;
        }

        public ParsedPrincipal commonName(String commonName) {
            this.commonName = commonName;
            return this;
        }

        public String organisation() {
            return this.organisation;
        }

        public ParsedPrincipal organisation(String organisation) {
            this.organisation = organisation;
            return this;
        }

        public String country() {
            return this.country;
        }

        public ParsedPrincipal country(String country) {
            this.country = country;
            return this;
        }

        public static ParsedPrincipal parse(String parsed) {
            String commonName = "-";
            String organisation = "-";
            String country = "-";
            List parts = Arrays.stream(parsed.split(",")).map(String::trim).collect(Collectors.toList());
            for (String part : parts) {
                if (part.startsWith(CN)) {
                    commonName = part.substring(CN.length());
                    continue;
                }
                if (part.startsWith(O)) {
                    organisation = part.substring(O.length());
                    continue;
                }
                if (!part.startsWith(C)) continue;
                country = part.substring(C.length());
            }
            return new ParsedPrincipal(commonName, organisation, country);
        }
    }
}

