/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.trust.pm;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.ui.dialog.trust.pm.CertificateModel;
import ch.transsoft.edec.util.DateUtil;
import ch.transsoft.edec.util.ui.LabelModel;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;

public class ImportCertificatePm {
    private final Action okAction = new AbstractAction(){
        {
            this.putValue("Name", Services.getText(100424));
            this.putValue("ShortDescription", Services.getText(100424));
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            ImportCertificatePm.this.shouldImport = true;
            ImportCertificatePm.this.closeWindowListener.run();
        }
    };
    private final Action cancelAction = new AbstractAction(){
        {
            this.putValue("Name", Services.getText(100425));
            this.putValue("ShortDescription", Services.getText(100425));
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            ImportCertificatePm.this.shouldImport = false;
            ImportCertificatePm.this.closeWindowListener.run();
        }
    };
    private final DefaultListModel<CertificateModel> certificates;
    private final LabelModel subjectC = new LabelModel();
    private final LabelModel subjectO = new LabelModel();
    private final LabelModel subjectCN = new LabelModel();
    private final LabelModel issuerC = new LabelModel();
    private final LabelModel issuerO = new LabelModel();
    private final LabelModel issuerCN = new LabelModel();
    private final LabelModel validFromModel = new LabelModel();
    private final LabelModel validUntilModel = new LabelModel();
    public boolean shouldImport = false;
    private Runnable closeWindowListener = () -> {};
    private CertificateModel selected;

    public ImportCertificatePm(List<CertificateModel> certificateDetails) {
        this.certificates = new DefaultListModel();
        this.certificates.addAll(certificateDetails);
        if (!certificateDetails.isEmpty()) {
            this.certificateSelectionChanged(certificateDetails.get(0));
        }
    }

    public void setCloseWindowListener(Runnable listener) {
        this.closeWindowListener = listener;
    }

    public void certificateSelectionChanged(CertificateModel selectedValue) {
        this.selected = selectedValue;
        if (selectedValue == null) {
            this.subjectC.setText("");
            this.subjectO.setText("");
            this.subjectCN.setText("");
            this.issuerC.setText("");
            this.issuerO.setText("");
            this.issuerCN.setText("");
            this.validFromModel.setText("");
            this.validUntilModel.setText("");
            return;
        }
        this.subjectC.setText(selectedValue.info().subject().country());
        this.subjectO.setText(selectedValue.info().subject().organisation());
        this.subjectCN.setText(selectedValue.info().subject().commonName());
        this.issuerC.setText(selectedValue.info().issuer().country());
        this.issuerO.setText(selectedValue.info().issuer().organisation());
        this.issuerCN.setText(selectedValue.info().issuer().commonName());
        this.validFromModel.setText(DateUtil.formatDateTime(selectedValue.certificate().getNotBefore()));
        this.validUntilModel.setText(DateUtil.formatDateTime(selectedValue.certificate().getNotAfter()));
    }

    public ListModel<CertificateModel> getCertificates() {
        return this.certificates;
    }

    public Action getCancelAction() {
        return this.cancelAction;
    }

    public LabelModel getIssuerC() {
        return this.issuerC;
    }

    public LabelModel getIssuerCN() {
        return this.issuerCN;
    }

    public LabelModel getIssuerO() {
        return this.issuerO;
    }

    public Action getOkAction() {
        return this.okAction;
    }

    public LabelModel getSubjectC() {
        return this.subjectC;
    }

    public LabelModel getSubjectCN() {
        return this.subjectCN;
    }

    public LabelModel getSubjectO() {
        return this.subjectO;
    }

    public LabelModel getValidFromModel() {
        return this.validFromModel;
    }

    public LabelModel getValidUntilModel() {
        return this.validUntilModel;
    }

    public CertificateModel getSelected() {
        return this.selected;
    }
}

