/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.ui.dialog.EscapeDialog;
import ch.transsoft.edec.ui.gui.control.Label;
import ch.transsoft.edec.ui.gui.control.LinkLabel;
import ch.transsoft.edec.ui.img.IconLoader;
import ch.transsoft.edec.util.DateUtil;
import ch.transsoft.edec.util.SystemUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class CertificateExpirationDialog
extends EscapeDialog {
    public CertificateExpirationDialog() {
        super(Services.getText(1182));
        this.setLayout(new BorderLayout());
        this.add((Component)this.createTitle(), "North");
        this.add((Component)this.createBody(), "Center");
        this.add(this.createButton(), "South");
        this.createBody();
    }

    private Component createButton() {
        JPanel result = new JPanel();
        result.setLayout(new MigLayout());
        JButton button = new JButton(Services.getText(212));
        result.add((Component)button, "push, tag ok");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                CertificateExpirationDialog.this.dispose();
            }
        });
        return result;
    }

    private static String getTitleString() {
        return Services.format(1180, SystemUtil.getCertificateEndDate());
    }

    private JPanel createBody() {
        JPanel result = new JPanel();
        result.setLayout(new MigLayout("", "[grow]", "[]70[]"));
        String text = "<html>" + Services.getText(1181) + "</html>";
        result.add(new LinkLabel("link", Services.getText(1179), text));
        return result;
    }

    private JPanel createTitle() {
        JPanel result = new JPanel();
        result.setBackground(Color.WHITE);
        result.setLayout(new MigLayout("", "[]push[]", "[50!]"));
        result.add(new Label("<html>" + CertificateExpirationDialog.getTitleString() + "</html>"));
        result.add((Component)new JLabel(IconLoader.getIcon("icon/ezv-35x35.png")), "right");
        return result;
    }

    public static Date getCertificateEndDate() {
        String endDateStr = SystemUtil.getCertificateEndDate();
        String[] segs = endDateStr.split("\\.");
        if (segs.length != 3) {
            return null;
        }
        int day = Integer.parseInt(segs[0]);
        int month = Integer.parseInt(segs[1]) - 1;
        int year = Integer.parseInt(segs[2]);
        Calendar calendar = DateUtil.createGregorianCalendar();
        calendar.set(year, month, day);
        return calendar.getTime();
    }

    public static boolean showCertificateExpirationWarning() {
        Date certificateEndDate = CertificateExpirationDialog.getCertificateEndDate();
        if (certificateEndDate == null) {
            return false;
        }
        Date threshold = DateUtil.add(new Date(), 40);
        return certificateEndDate.before(threshold);
    }
}

