/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.action.IActionService;
import ch.transsoft.edec.service.gui.IGuiService;
import ch.transsoft.edec.service.text.ITextService;
import ch.transsoft.edec.ui.gui.Design;
import ch.transsoft.edec.ui.gui.control.DefaultPanel;
import ch.transsoft.edec.ui.gui.control.tabs.ColorTabbedPane;
import ch.transsoft.edec.ui.gui.control.tabs.TabbedPane;
import ch.transsoft.edec.ui.gui.evvimport.bordereau.BordereauPanel;
import ch.transsoft.edec.ui.gui.evvimport.receipt.ReceiptListPanel;
import ch.transsoft.edec.ui.img.IconLoader;
import ch.transsoft.edec.ui.pm.EvvImportPm;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;

public class EvvImportPanel
extends JPanel {
    private static final String ICON_DOCLIST = "icon/sending-32x36.png";
    private static final String ICON_BORDEREAU = "icon/sendinglist-32x36.png";
    private DefaultPanel sendingPanelContainer = new DefaultPanel();
    public static final int BORDEREAU_TAB = 0;
    public static final int RECEIPT_TAB = 1;
    private TabbedPane tabbedPane;
    private final EvvImportPm evvImportPm;

    public EvvImportPanel(EvvImportPm EvvImportPm2) {
        this.evvImportPm = EvvImportPm2;
        this.sendingPanelContainer.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.setBackground(Design.BG);
        this.add(this.createToolbarPanel(), "North");
        this.add(this.createContent(), "Center");
        this.addTabListener();
    }

    private void addTabListener() {
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e2) {
                Services.get(IActionService.class).tabChanged(EvvImportPanel.this.tabbedPane.getSelectedIndex());
            }
        });
    }

    private Component createToolbarPanel() {
        DefaultPanel result = new DefaultPanel();
        result.setLayout(new MigLayout("fill", "0[grow]0[]0", "0[]0"));
        result.add(Services.get(IActionService.class).createToolbar(), "growx");
        result.add((Component)Services.get(IGuiService.class).getStatusDisplay(), "growy");
        return result;
    }

    private Component createContent() {
        this.tabbedPane = new ColorTabbedPane(new Color[]{Design.DOCLIST_TAB_SELECTED, Design.BORDEREAU_LIST_TAB_SELECTED}, new Color[]{null, null});
        this.tabbedPane.setOpaque(false);
        this.tabbedPane.setPreferredSize(new Dimension(500, 500));
        Font font = new Font(this.tabbedPane.getFont().getName(), 1, 12);
        this.tabbedPane.setFont(font);
        this.tabbedPane.addTab(this.getText(1401), this.getIcon(ICON_BORDEREAU), new BordereauPanel(this.evvImportPm));
        this.tabbedPane.addTab(this.getText(1400), this.getIcon(ICON_DOCLIST), new ReceiptListPanel(this.evvImportPm));
        return this.tabbedPane;
    }

    public void selectBordereau() {
        this.tabbedPane.setSelectedIndex(0);
    }

    public void selectDocs(String searchText) {
        this.tabbedPane.setSelectedIndex(1);
        try {
            Services.get(IGuiService.class).setHourGlassCursor(true);
            this.evvImportPm.getReceiptIndexPm().setSearchText(searchText);
        }
        finally {
            Services.get(IGuiService.class).setHourGlassCursor(false);
        }
    }

    private Icon getIcon(String string) {
        return IconLoader.getIcon(string);
    }

    private String getText(int id) {
        return Services.get(ITextService.class).getText(id);
    }

    public boolean isTabBordereauSelected() {
        return this.tabbedPane.getSelectedIndex() == 0;
    }

    public boolean isTabReceiptSelected() {
        return this.tabbedPane.getSelectedIndex() == 1;
    }
}

