/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.bar;

import ch.transsoft.edec.model.sending.OperatingMode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.action.ActionBase;
import ch.transsoft.edec.service.action.IActionService;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.config.IConfigServiceListener;
import ch.transsoft.edec.service.text.ITextService;
import ch.transsoft.edec.ui.action.MasterDataAddressAction;
import ch.transsoft.edec.ui.action.MasterDataCarrierAction;
import ch.transsoft.edec.ui.action.MasterDataConsignorAction;
import ch.transsoft.edec.ui.action.MasterDataCurrencyAction;
import ch.transsoft.edec.ui.action.MasterDataDeclarantAction;
import ch.transsoft.edec.ui.action.MasterDataGenericTermAction;
import ch.transsoft.edec.ui.action.MasterDataGoodsItemsAction;
import ch.transsoft.edec.ui.action.OpenInfoDialogAction;
import ch.transsoft.edec.ui.action.OpenTaresAction;
import ch.transsoft.edec.ui.action.OpenWebbrowserAction;
import ch.transsoft.edec.ui.pm.IModulePm;
import ch.transsoft.edec.util.Check;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;

public abstract class MenuBase {
    private JRadioButtonMenuItem productiveItem;
    private JRadioButtonMenuItem testSystemItem;

    protected JMenu createMasterDataMenu() {
        JMenu menu = new JMenu(Services.getText(101));
        menu.add(this.getAction(MasterDataConsignorAction.class));
        menu.add(this.getAction(MasterDataDeclarantAction.class));
        menu.addSeparator();
        menu.add(this.getAction(MasterDataAddressAction.class));
        menu.add(this.getAction(MasterDataCarrierAction.class));
        menu.addSeparator();
        menu.add(this.getAction(MasterDataGoodsItemsAction.class));
        menu.add(this.getAction(MasterDataGenericTermAction.class));
        menu.addSeparator();
        menu.add(this.getAction(MasterDataCurrencyAction.class));
        return menu;
    }

    protected JMenu createHelpMenu() {
        JMenu menu = new JMenu(Services.getText(117));
        this.addResourceItem(menu, Services.getText(131), 132, "icon/Browser-small.png", false);
        this.addResourceItem(menu, Services.getText(138), 139, "icon/Browser-small.png", false);
        menu.add(new OpenTaresAction());
        menu.addSeparator();
        this.addResourceItem(menu, Services.getText(124), 125, "icon/Browser-small.png", false);
        this.addResourceItem(menu, Services.getText(120), 121, "icon/pdf-small.png", false);
        this.addResourceItem(menu, Services.getText(118), 119, "icon/Browser-small.png", false);
        this.addResourceItem(menu, Services.getText(142), 143, "icon/Browser-small.png", true);
        this.addResourceItem(menu, Services.getText(126), 127, "icon/Teamviewer-small.png", true);
        String version = Services.get(IConfigService.class).getVersionString();
        this.addResourceItem(menu, Services.format(122, version), 123, "icon/Browser-small.png", false);
        menu.add(this.getAction(OpenInfoDialogAction.class));
        return menu;
    }

    protected void addResourceItem(JMenu menu, String name, int urlId, String icon, boolean separatorAfter) {
        String url = Services.getText(urlId);
        if (name.isEmpty() || url.isEmpty()) {
            return;
        }
        menu.add(new OpenWebbrowserAction(name, url, icon));
        if (separatorAfter) {
            menu.addSeparator();
        }
    }

    protected void addLanguageSelection(JMenu menu) {
        JMenu languageMenu = new JMenu(Services.getText(3000));
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem de = new JRadioButtonMenuItem(Services.getText(3001));
        group.add(de);
        languageMenu.add(de);
        JRadioButtonMenuItem fr = new JRadioButtonMenuItem(Services.getText(3002));
        group.add(fr);
        languageMenu.add(fr);
        menu.add(languageMenu);
        switch (Services.get(ITextService.class).getCurrentLanguage()) {
            case de: {
                de.setSelected(true);
                break;
            }
            case fr: {
                fr.setSelected(true);
                break;
            }
            default: {
                Check.fail("unexpected language");
            }
        }
        fr.addActionListener(e2 -> Services.get(ITextService.class).setCurrentLanguage(ITextService.Language.fr));
        de.addActionListener(e2 -> Services.get(ITextService.class).setCurrentLanguage(ITextService.Language.de));
    }

    protected void addModeSelection(JMenu menu, IModulePm modulePm) {
        ButtonGroup group = new ButtonGroup();
        this.productiveItem = new JRadioButtonMenuItem(Services.getText(106));
        group.add(this.productiveItem);
        menu.add(this.productiveItem);
        this.testSystemItem = new JRadioButtonMenuItem(Services.getText(107));
        this.testSystemItem.setToolTipText(Services.format(108, 107));
        group.add(this.testSystemItem);
        menu.add(this.testSystemItem);
        this.addUserGestureListeners();
        this.addConfigListener(modulePm);
        this.updateDemoRadios();
    }

    protected void addConfigListener(IModulePm modulePm) {
        modulePm.add(this.getConfigService().add(new IConfigServiceListener(){

            @Override
            public void rootChanged() {
            }

            @Override
            public void modeChanged(boolean isDemo) {
            }

            @Override
            public void configurationChanged() {
                MenuBase.this.updateDemoRadios();
            }
        }));
    }

    protected void updateDemoRadios() {
        if (!this.getConfigService().hasCertificate()) {
            this.productiveItem.setEnabled(false);
            this.testSystemItem.setEnabled(false);
            this.productiveItem.setSelected(false);
            this.testSystemItem.setSelected(false);
        } else if (this.getConfigService().hasLicenseForActiveModule()) {
            this.productiveItem.setToolTipText(Services.format(108, 106));
            this.productiveItem.setEnabled(true);
            this.testSystemItem.setEnabled(true);
            this.productiveItem.setSelected(this.getConfigService().getOperatingModeForActiveModule() == OperatingMode.production);
            this.testSystemItem.setSelected(this.getConfigService().getOperatingModeForActiveModule() == OperatingMode.test);
        } else {
            this.productiveItem.setEnabled(false);
            this.testSystemItem.setEnabled(true);
            this.productiveItem.setToolTipText(Services.getText(109));
            this.testSystemItem.setSelected(true);
        }
    }

    protected IConfigService getConfigService() {
        return Services.get(IConfigService.class);
    }

    protected void addUserGestureListeners() {
        this.productiveItem.addActionListener(e2 -> this.getConfigService().setOperatingMode(OperatingMode.production));
        this.testSystemItem.addActionListener(e2 -> this.getConfigService().setOperatingMode(OperatingMode.test));
    }

    protected <T extends ActionBase> Action getAction(Class<T> action) {
        return Services.get(IActionService.class).getAction(action);
    }
}

