/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.control;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.service.text.ITextService;
import ch.transsoft.edec.ui.img.IconLoader;
import ch.transsoft.edec.util.DocumentUtil;
import java.awt.AlphaComposite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class InfoIcon
extends JComponent {
    private ImageIcon icon;
    private final String url;

    public InfoIcon() {
        this((String)null, true);
    }

    public InfoIcon(Integer helpPage) {
        this(helpPage, false);
    }

    public InfoIcon(Integer helpPage, boolean big) {
        this(helpPage == null ? null : InfoIcon.getUrl(helpPage), big);
    }

    public InfoIcon(String url, boolean big) {
        this.url = url;
        if (url == null) {
            return;
        }
        this.icon = IconLoader.getIcon(big ? "icon/Info-blue-small.png" : "icon/Info-nano.png");
        this.setPreferredSize(new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight()));
        this.setToolTipText(Services.getText(1500));
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addMouseListener();
    }

    private void addMouseListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                if (e2.getClickCount() == 1) {
                    InfoIcon.this.openBrowser();
                }
            }
        });
    }

    private void openBrowser() {
        try {
            DocumentUtil.openBrowser(this.url);
        }
        catch (Exception e2) {
            Services.get(ILoggingService.class).logAndReport(e2, Services.getText(624));
        }
    }

    private static String getUrl(Integer helpPage) {
        if (Services.get(ITextService.class).getCurrentLanguage() == ITextService.Language.de) {
            return "https://www.transsoft.ch/expovit_e_dec/dokumentation/felder/" + helpPage + ".html";
        }
        return "https://www.transsoft.ch/fr/expovit_e_dec/documentation/champs/" + helpPage + ".html";
    }

    @Override
    protected void paintComponent(Graphics g2) {
        if (this.url == null) {
            return;
        }
        Graphics2D g22 = (Graphics2D)g2;
        if (!this.isEnabled()) {
            g22.setComposite(AlphaComposite.getInstance(3, 0.3f));
        }
        this.icon.paintIcon(this, g22, 0, 0);
    }
}

