/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.control;

import ch.transsoft.edec.util.DocumentUtil;
import ch.transsoft.edec.util.disposable.ListenerList;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.html.HTMLDocument;

public class LinkLabel
extends JEditorPane {
    private final Map<String, ListenerList<Runnable>> listeners = new HashMap<String, ListenerList<Runnable>>();

    public LinkLabel(String href, String url, String text) {
        this(text);
        this.addLinkListener(href, () -> DocumentUtil.openBrowser(url));
    }

    public LinkLabel(String text) {
        super("text/html", text);
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setOpaque(false);
        this.setEditable(false);
        this.setDefaultFont();
        this.addHyperlinkListener(hle -> {
            if (HyperlinkEvent.EventType.ACTIVATED.equals(hle.getEventType())) {
                for (Runnable listener : this.getListenerList(hle.getDescription())) {
                    listener.run();
                }
            }
        });
    }

    private void setDefaultFont() {
        Font font = UIManager.getFont("Label.font");
        this.setFont(font);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.getDocument() == null) {
            return;
        }
        int fontSize = (int)((double)font.getSize() * font.getTransform().getScaleX());
        String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + fontSize + "pt; }";
        ((HTMLDocument)this.getDocument()).getStyleSheet().addRule(bodyRule);
    }

    public void addLinkListener(String href, Runnable action) {
        this.getListenerList(href).add(action);
    }

    private ListenerList<Runnable> getListenerList(String href) {
        ListenerList<Runnable> result = this.listeners.get(href);
        if (result == null) {
            result = new ListenerList();
            this.listeners.put(href, result);
        }
        return result;
    }
}

