/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.control.combo;

import ch.transsoft.edec.service.validate.ErrorInfo;
import ch.transsoft.edec.ui.gui.control.combo.ComboBoxUI;
import ch.transsoft.edec.ui.gui.control.combo.SelectionFieldRenderer;
import ch.transsoft.edec.ui.pm.model.IPmListener;
import ch.transsoft.edec.ui.pm.model.ISelectionPm;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComboBox;

public class SelectionField<T>
extends JComboBox<T> {
    private ISelectionPm<T> model;
    private final boolean drawKey;
    private final int spacer;

    public SelectionField(ISelectionPm<T> model) {
        this(true, 30);
        this.setModel(model);
    }

    public SelectionField(ISelectionPm<T> model, int spacer) {
        this(true, spacer);
        this.setModel(model);
    }

    public SelectionField() {
        this(true, 30);
    }

    public SelectionField(boolean drawKey, int spacer) {
        this.drawKey = drawKey;
        this.spacer = spacer;
        this.setUI(new ComboBoxUI());
        Font f2 = this.getFont();
        this.setFont(new Font(f2.getName(), 0, f2.getSize()));
    }

    @Override
    public void setModel(ISelectionPm<T> model) {
        super.setModel(model);
        this.model = model;
        this.setErrorState(model.getErrorInfo());
        this.addErrorListener();
        this.addEnableListener();
        SelectionFieldRenderer renderer = new SelectionFieldRenderer(this.drawKey, this.spacer, 2, 4, this.createSelectionFieldContext());
        this.setRenderer(renderer);
    }

    private void addErrorListener() {
        this.model.addErrorListener(this::setErrorState);
    }

    private void setErrorState(ErrorInfo info) {
        this.setToolTipText(info.getMesage());
        this.repaint();
    }

    private void addEnableListener() {
        this.setEnabled(this.model.isEnabled());
        this.model.add(new IPmListener(){

            @Override
            public void enabled(boolean value) {
                SelectionField.this.setEnabled(value);
            }

            @Override
            public void editable(boolean editable, String reason) {
                SelectionField.this.setEnabled(editable);
                SelectionField.this.setToolTipTextIfNotEmpty(reason);
            }
        });
    }

    private void setToolTipTextIfNotEmpty(String tooltip) {
        if (tooltip == null || tooltip.isEmpty()) {
            return;
        }
        this.setToolTipText(tooltip);
    }

    private SelectionFieldRenderer.ISelectionFieldRendererContext createSelectionFieldContext() {
        return new SelectionFieldRenderer.ISelectionFieldRendererContext(){

            @Override
            public ErrorInfo getErrorInfo() {
                return SelectionField.this.model.getErrorInfo();
            }

            @Override
            public boolean isMandatory() {
                return SelectionField.this.model.isMandatory();
            }
        };
    }

    @Override
    protected void paintComponent(Graphics g2) {
        Graphics2D g22 = (Graphics2D)g2;
        super.paintComponent(g22);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(0, 0);
    }
}

