/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.control.combo;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.masterdataezv.DomainValue;
import ch.transsoft.edec.service.masterdataezv.IDomainData;
import ch.transsoft.edec.service.masterdataezv.IMasterDataEZVService;
import ch.transsoft.edec.service.masterdataezv.internal.Domain;
import ch.transsoft.edec.service.validate.ErrorInfo;
import ch.transsoft.edec.ui.gui.Design;
import ch.transsoft.edec.ui.pm.model.IPmListener;
import ch.transsoft.edec.ui.pm.model.SelectionPm;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

public class SelectionRadioGroup {
    private final List<JRadioButton> buttons = new ArrayList<JRadioButton>();
    private SelectionPm model;
    private final ButtonGroup group;
    private final IDomainData data;

    public SelectionRadioGroup(Domain domain) {
        this.data = Services.get(IMasterDataEZVService.class).getDomainData(domain, false);
        this.group = new ButtonGroup();
        for (DomainValue current : this.data) {
            JRadioButton button = new JRadioButton(current.getDesc());
            button.setBackground(Design.ERROR_COLOR);
            button.setOpaque(true);
            this.buttons.add(button);
            this.group.add(button);
            this.registerListener(button);
        }
    }

    private void registerListener(JRadioButton button) {
        button.addActionListener(e2 -> {
            int i2 = this.buttons.indexOf(button);
            DomainValue selected = this.model.getElementAt(i2);
            this.model.setSelectedItem(selected);
        });
    }

    public void setModel(SelectionPm model) {
        this.model = model;
        this.setErrorState(model.getErrorInfo());
        this.addErrorListener();
        this.addEnableListener();
        if (!model.isInitialized()) {
            this.group.clearSelection();
            return;
        }
        int index = model.getIndexOf(model.getSelectedItem());
        this.buttons.get(index).setSelected(true);
    }

    public JRadioButton getRadioButton(int index) {
        return this.buttons.get(index);
    }

    private void addEnableListener() {
        this.setEnable(this.model.isEnabled());
        this.model.add(new IPmListener(){

            @Override
            public void enabled(boolean value) {
                SelectionRadioGroup.this.setEnable(value);
            }

            @Override
            public void editable(boolean editable, String reason) {
            }
        });
    }

    private void setEnable(boolean value) {
        for (JRadioButton current : this.buttons) {
            current.setEnabled(value);
        }
    }

    private void addErrorListener() {
        this.model.addErrorListener(this::setErrorState);
    }

    private void setErrorState(ErrorInfo info) {
        for (JRadioButton button : this.buttons) {
            this.setErrorState(button, info);
        }
    }

    private void setErrorState(JRadioButton button, ErrorInfo info) {
        button.setToolTipText(info.getMesage());
        button.setOpaque(info.hasError());
        button.repaint();
    }
}

