/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.control.combo;

import ch.transsoft.edec.ui.gui.control.combo.StateAwareComboBoxModel;
import ch.transsoft.edec.util.disposable.IDisposable;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;

public class StateAwareComboBox<E>
extends JComboBox<E> {
    private IDisposable stateListenerDisposable = null;

    public StateAwareComboBox(ComboBoxModel<E> aModel) {
        super(aModel);
    }

    @Override
    public void setModel(ComboBoxModel<E> aModel) {
        super.setModel(aModel);
        if (this.stateListenerDisposable != null) {
            this.stateListenerDisposable.dispose();
        }
        this.stateListenerDisposable = null;
        if (aModel instanceof StateAwareComboBoxModel) {
            StateAwareComboBoxModel model = (StateAwareComboBoxModel)aModel;
            this.setEnabled(model.getEnabledState());
            this.stateListenerDisposable = model.addStateListener(() -> this.setEnabled(model.getEnabledState()));
        }
    }
}

