/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.control.searchtable;

import ch.transsoft.edec.model.infra.node.DecimalNode;
import ch.transsoft.edec.model.infra.node.EdecDateNode;
import ch.transsoft.edec.model.infra.node.IntegralNode;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.ui.gui.Design;
import ch.transsoft.edec.ui.gui.control.searchtable.CopyPasteAdapter;
import ch.transsoft.edec.ui.gui.control.searchtable.DecimalRenderer;
import ch.transsoft.edec.ui.gui.control.searchtable.IntegralRenderer;
import ch.transsoft.edec.ui.gui.control.searchtable.StringRenderer;
import ch.transsoft.edec.ui.gui.control.table.ToolTipJXTable;
import ch.transsoft.edec.ui.gui.sendinglist.AllColumnFilter;
import java.awt.Color;
import java.util.ArrayDeque;
import java.util.regex.Pattern;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.CompoundHighlighter;
import org.jdesktop.swingx.decorator.FilterPipeline;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.decorator.PatternFilter;
import org.jdesktop.swingx.decorator.SearchPredicate;
import org.jdesktop.swingx.search.PatternModel;

public class SearchTable
extends ToolTipJXTable {
    public static final int INNER_GAP = 4;
    private final CompoundHighlighter tableHighlighters;
    private final ColorHighlighter matchHighlighter;
    private final PatternFilter tablePatternFilter;
    private FilterPipeline tableFilterPipeline;
    private final PatternModel patternModel = new PatternModel();
    private final ArrayDeque<Integer> searchPos = new ArrayDeque();
    private boolean filterEnabled = false;

    public SearchTable(TableModel pm) {
        this(pm, false);
    }

    public SearchTable(TableModel pm, boolean multiSelection) {
        super(pm);
        this.setFocusable(true);
        this.setCellSelectionEnabled(false);
        this.setRowSelectionAllowed(true);
        if (multiSelection) {
            this.getSelectionModel().setSelectionMode(2);
        } else {
            this.getSelectionModel().setSelectionMode(0);
        }
        this.getTableHeader().setReorderingAllowed(false);
        this.tablePatternFilter = new AllColumnFilter(this);
        this.tableHighlighters = new CompoundHighlighter(new Highlighter[0]);
        this.tableHighlighters.addHighlighter(HighlighterFactory.createSimpleStriping(new Color(250, 250, 250)));
        this.matchHighlighter = new ColorHighlighter(HighlightPredicate.NEVER, Design.SEARCH_BG, Design.SEARCH_FG);
        this.tableHighlighters.addHighlighter(this.matchHighlighter);
        this.setHighlighters(this.tableHighlighters);
        new CopyPasteAdapter(this);
        this.setDefaultRenderer(EdecDateNode.class, new StringRenderer());
        this.setDefaultRenderer(StringNode.class, new StringRenderer());
        this.setDefaultRenderer(DecimalNode.class, new DecimalRenderer());
        this.setDefaultRenderer(IntegralNode.class, new IntegralRenderer());
    }

    public void searchTextChanged(String text) {
        if (this.filterEnabled) {
            this.filter(text);
        }
        this.highlight(text);
        this.patternModel.setRawText(text);
        this.findNext(-1);
        this.searchPos.clear();
    }

    public void searchNext(boolean backwards) {
        if (backwards) {
            this.findLast();
        } else {
            this.searchPos.push(this.patternModel.getFoundIndex() - 1);
            this.findNext(this.patternModel.getFoundIndex());
        }
    }

    private void findLast() {
        if (this.searchPos.isEmpty()) {
            return;
        }
        int index = this.searchPos.pop();
        if (index < 0 || index >= this.getModel().getRowCount()) {
            return;
        }
        this.patternModel.setFoundIndex(index);
        this.getSelectionModel().setSelectionInterval(index, index);
    }

    private FilterPipeline getFilterPipeline() {
        if (this.tableFilterPipeline == null) {
            this.tableFilterPipeline = new FilterPipeline(this.tablePatternFilter);
        }
        return this.tableFilterPipeline;
    }

    public boolean findNext(int start) {
        int foundIndex = this.getSearchable().search(this.patternModel.getPattern(), start, false);
        this.patternModel.setFoundIndex(foundIndex);
        if (foundIndex == -1) {
            this.getSelectionModel().clearSelection();
        }
        return foundIndex != -1;
    }

    private void highlight(String text) {
        SearchPredicate predicate = new SearchPredicate(this.createPattern(text));
        this.matchHighlighter.setHighlightPredicate(predicate);
    }

    public void filter(String text) {
        this.tablePatternFilter.setPattern(this.createPattern(text));
        FilterPipeline filters = this.getFilterPipeline();
        this.setFilters(filters);
    }

    private Pattern createPattern(String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        return Pattern.compile(Pattern.quote(text), 2);
    }

    public boolean hasSelectedRow() {
        return this.getSelectedRow() != -1;
    }

    public int getSelectionIndex() {
        return this.convertRowIndexToModel(this.getSelectedRow());
    }

    public int[] getSelectionIndices() {
        int[] selection = this.getSelectedRows();
        int[] result = new int[selection.length];
        for (int i2 = 0; i2 < result.length; ++i2) {
            result[i2] = this.convertRowIndexToModel(selection[i2]);
        }
        return result;
    }

    public void enableFiltering(boolean value) {
        this.filterEnabled = value;
    }
}

