/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.control.table;

import ch.transsoft.edec.model.infra.node.BooleanNode;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import net.miginfocom.swing.MigLayout;

public class BooleanRenderer
extends JPanel
implements TableCellRenderer {
    private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private static final Border focusBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
    private final JCheckBox box = new JCheckBox();

    public BooleanRenderer() {
        this.setLayout(new MigLayout("fillx", "[center]", "0[]0"));
        this.box.setOpaque(false);
        this.add(this.box);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        this.setBorder(hasFocus ? focusBorder : noFocusBorder);
        if (value == null) {
            return this;
        }
        BooleanNode node = (BooleanNode)value;
        this.box.setSelected(node.getValue());
        this.setMaximumSize(new Dimension(30, 30));
        this.setPreferredSize(new Dimension(30, 30));
        return this;
    }
}

