/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.control.table;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;

public abstract class CellEditorBase
extends AbstractCellEditor {
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JComponent result = this.doGetTableCellEditorComponent(table, value, isSelected, row, column);
        this.addFocusListener(result, table);
        return result;
    }

    private void addFocusListener(Component result, final JTable table) {
        result.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e2) {
                if (e2.getOppositeComponent() == null) {
                    return;
                }
                JTable oppositeParentTable = CellEditorBase.this.getParentTable(e2.getOppositeComponent());
                if (oppositeParentTable == null || table != oppositeParentTable) {
                    CellEditorBase.this.stopCellEditing();
                }
            }

            @Override
            public void focusGained(FocusEvent e2) {
            }
        });
    }

    private JTable getParentTable(Component result) {
        for (Component current = result; current != null; current = current.getParent()) {
            if (!(current instanceof JTable)) continue;
            return (JTable)current;
        }
        return null;
    }

    protected abstract JComponent doGetTableCellEditorComponent(JTable var1, Object var2, boolean var3, int var4, int var5);
}

