/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.control.table;

import ch.transsoft.edec.model.infra.node.INode;
import ch.transsoft.edec.model.infra.node.ListEntry;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.ui.pm.model.TablePm;
import java.util.Comparator;
import org.jdesktop.swingx.JXTable;

public class EmptyLineComparator<T extends ListEntry<T>>
implements Comparator<StringNode> {
    private final TablePm<T> tablePm;
    private final JXTable table;
    private final int columnIndex;

    public EmptyLineComparator(TablePm<T> tablePm, JXTable table, int columnIndex) {
        this.tablePm = tablePm;
        this.table = table;
        this.columnIndex = columnIndex;
    }

    @Override
    public int compare(StringNode o1, StringNode o2) {
        boolean isAscending = this.table.getSortOrder(this.columnIndex).isAscending();
        if (this.isEmptyLine(o1)) {
            return isAscending ? 1 : -1;
        }
        if (this.isEmptyLine(o2)) {
            return isAscending ? -1 : 1;
        }
        String s1 = o1.getValue();
        String s2 = o2.getValue();
        try {
            long l1 = Long.parseLong(s1);
            long l2 = Long.parseLong(s2);
            return (int)Math.signum(l1 - l2);
        }
        catch (NumberFormatException e2) {
            return s1.compareTo(s2);
        }
    }

    private boolean isEmptyLine(StringNode node) {
        T entry = this.getListEntry(node);
        if (entry == null) {
            return false;
        }
        return this.tablePm.isEmptyLine(entry);
    }

    private T getListEntry(INode<?> node) {
        while (node != null) {
            if (node instanceof ListEntry) {
                return (T)((ListEntry)node);
            }
            node = node.getParent();
        }
        return null;
    }
}

