/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.control.table;

import ch.transsoft.edec.model.infra.node.IntegralNode;
import ch.transsoft.edec.ui.gui.control.table.CellEditorBase;
import ch.transsoft.edec.ui.gui.control.table.TableTextField;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class IntegralCellEditor
extends CellEditorBase
implements TableCellEditor {
    private JTextField textField;
    private IntegralNode node;

    @Override
    public JComponent doGetTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.node = (IntegralNode)value;
        this.textField = new TableTextField(this, this.node.getStringValue());
        this.textField.setHorizontalAlignment(4);
        this.textField.setCaretPosition(0);
        this.textField.moveCaretPosition(this.textField.getDocument().getLength());
        return this.textField;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.textField.getText().isEmpty()) {
            return null;
        }
        try {
            NumberFormat formatter = this.node.getFormat();
            return formatter.parse(formatter.format(formatter.parse(this.textField.getText())));
        }
        catch (ParseException e2) {
            return this.getOldValue();
        }
    }

    private Object getOldValue() {
        if (!this.node.isInitialized()) {
            return null;
        }
        return this.node.getValue();
    }
}

