/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.control.table;

import ch.transsoft.edec.ui.gui.Design;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class NonEditableRowRenderer
implements TableCellRenderer {
    private final TableCellRenderer parent;
    private final int column;

    public NonEditableRowRenderer(TableCellRenderer parent, int column) {
        this.parent = parent;
        this.column = column;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component c2 = this.parent.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        c2.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        if (table.getModel().isCellEditable(row, this.column)) {
            return c2;
        }
        c2.setBackground(Design.NON_EDITABLE_TABLE_COLOR);
        if (!(c2 instanceof JCheckBox)) {
            return c2;
        }
        c2.setEnabled(false);
        return c2;
    }
}

