/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.control.table;

import ch.transsoft.edec.model.infra.node.SelectionNode;
import ch.transsoft.edec.ui.img.IconLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class SelectionCellRenderer
extends JPanel
implements TableCellRenderer {
    private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private static final Border focusBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
    private SelectionNode node;
    private static final ImageIcon arrow = IconLoader.getIcon("icon/Combo-arrow.png");
    private final int gap;
    private static final int ICON_WIDTH = 20;
    JLabel sizeHelperJLabel = new JLabel();

    public SelectionCellRenderer() {
        this(30);
    }

    public SelectionCellRenderer(int gap) {
        this.gap = gap;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        this.setBorder(hasFocus ? focusBorder : noFocusBorder);
        if (value == null) {
            this.node = null;
            return this;
        }
        this.node = (SelectionNode)value;
        this.sizeHelperJLabel.setText(this.node.getValue().getDesc());
        return this;
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        if (this.node == null) {
            return;
        }
        g2.drawString(this.node.getValue().getKey(), 1, 16);
        Rectangle oldClip = g2.getClip().getBounds();
        g2.setClip(new Rectangle(0, 0, this.getWidth() - 20, oldClip.height));
        g2.drawString(this.node.getValue().getDesc(), this.gap + 1, 16);
        g2.setClip(oldClip);
        g2.drawImage(arrow.getImage(), this.getWidth() - 20, 0, null);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = this.sizeHelperJLabel.getPreferredSize();
        preferredSize.width = preferredSize.width + this.gap + 20;
        return preferredSize;
    }
}

