/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.control.table;

import ch.transsoft.edec.model.infra.node.BooleanNode;
import ch.transsoft.edec.model.infra.node.DateNode;
import ch.transsoft.edec.model.infra.node.DecimalNode;
import ch.transsoft.edec.model.infra.node.ITableAdapter;
import ch.transsoft.edec.model.infra.node.IntegralNode;
import ch.transsoft.edec.model.infra.node.ListEntry;
import ch.transsoft.edec.model.infra.node.SelectionNode;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.ui.gui.control.table.BooleanCellEditor;
import ch.transsoft.edec.ui.gui.control.table.BooleanRenderer;
import ch.transsoft.edec.ui.gui.control.table.DateCellEditor;
import ch.transsoft.edec.ui.gui.control.table.DecimalCellEditor;
import ch.transsoft.edec.ui.gui.control.table.DecimalRenderer;
import ch.transsoft.edec.ui.gui.control.table.DeleteButton;
import ch.transsoft.edec.ui.gui.control.table.DeleteButtonRenderer;
import ch.transsoft.edec.ui.gui.control.table.ErrorHighlighter;
import ch.transsoft.edec.ui.gui.control.table.IntegralCellEditor;
import ch.transsoft.edec.ui.gui.control.table.IntegralRenderer;
import ch.transsoft.edec.ui.gui.control.table.SelectionCellEditor;
import ch.transsoft.edec.ui.gui.control.table.SelectionCellRenderer;
import ch.transsoft.edec.ui.gui.control.table.StringCellEditor;
import ch.transsoft.edec.ui.gui.control.table.ToolTipJXTable;
import ch.transsoft.edec.ui.pm.model.TablePm;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.TableUtil;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jdesktop.swingx.JXTable;

public class Table<T extends ListEntry<T>>
extends JScrollPane {
    private final JXTable table;
    private static final int HEIGHT = 22;
    private TablePm<T> tablePm;
    private final ITableAdapter[] adapters;

    public Table(TablePm<T> listPm, int height, ITableAdapter[] adapters) {
        this(height, adapters);
        this.setModel(listPm);
        this.addContextMenu(listPm);
    }

    public Table(int height, ITableAdapter[] adapters) {
        this.adapters = adapters;
        this.table = this.instantiateTable();
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setSelectionMode(0);
        this.table.setPreferredScrollableViewportSize(new Dimension(0, height));
        this.table.setFillsViewportHeight(true);
        this.table.setRowHeight(22);
        this.table.setSurrendersFocusOnKeystroke(true);
        this.table.setShowGrid(true);
        this.table.setShowHorizontalLines(true);
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "startEditing");
        this.registerEditors();
        this.registerRenderers();
        this.addMouseListener();
        this.addKeyListener();
        this.setViewportView(this.table);
        TableUtil.enableRightMouseButtonSelection(this.table);
    }

    public TablePm<T> getTableModel() {
        return this.tablePm;
    }

    public ITableAdapter[] getAdapters() {
        return this.adapters;
    }

    private void addContextMenu(final TablePm<T> listPm) {
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e2) {
                if (e2.getButton() == 3) {
                    Table.this.showPopUp(e2, listPm);
                }
            }
        });
    }

    private void showPopUp(MouseEvent e2, TablePm<T> listPm) {
        JPopupMenu menu = new JPopupMenu();
        List<Action> contextMenu = listPm.getContextMenu();
        if (contextMenu.isEmpty()) {
            return;
        }
        for (Action current : contextMenu) {
            menu.add(current);
        }
        menu.show(e2.getComponent(), e2.getX(), e2.getY());
    }

    protected JXTable instantiateTable() {
        ToolTipJXTable table = new ToolTipJXTable();
        table.setSortable(false);
        return table;
    }

    public void setModel(TablePm<T> tablePm) {
        if (this.tablePm != null) {
            this.table.getSelectionModel().removeListSelectionListener(this.tablePm);
        }
        this.tablePm = tablePm;
        this.table.setModel(tablePm);
        this.addErrorListener();
        this.addLineAddedListener();
        this.configureManipulatorColumn();
        this.applyAdapters(this.table, this.adapters);
        this.table.getSelectionModel().addListSelectionListener(tablePm);
        this.addErrorListener();
    }

    private void addLineAddedListener() {
        this.tablePm.addTableListener(new TablePm.ITableListener(){

            @Override
            public void scrollToRow(int rowIndex) {
                Table.this.scrollToRow(rowIndex);
            }

            @Override
            public void selectRow(int index) {
                Table.this.table.changeSelection(index, 0, false, false);
            }
        });
    }

    private void addErrorListener() {
        this.tablePm.addErrorListener(errorInfo -> this.repaint());
    }

    private void configureManipulatorColumn() {
        this.table.getColumnModel().getColumn(0).setMaxWidth(20);
        this.table.getColumnModel().getColumn(0).setMinWidth(20);
    }

    private void addKeyListener() {
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e2) {
                if (e2.getKeyChar() == ' ') {
                    Table.this.tablePm.mouseClicked(Table.this.table.getSelectedRow(), Table.this.table.getSelectedColumn(), 0);
                }
            }
        });
    }

    private void addMouseListener() {
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e2) {
                if (e2.getY() > 22 * Table.this.tablePm.getRowCount()) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(e2)) {
                    return;
                }
                Table.this.tablePm.mouseClicked(Table.this.table.getSelectedRow(), Table.this.table.getSelectedColumn(), e2.getClickCount());
            }
        });
    }

    private void applyAdapters(JTable table, ITableAdapter[] adapters) {
        for (int i2 = 0; i2 < adapters.length; ++i2) {
            ITableAdapter adapter = adapters[i2];
            TableColumn col = table.getColumnModel().getColumn(i2 + 1);
            if (adapter.getCellEditor() != null) {
                col.setCellEditor(this.createCellEditor(adapter));
            }
            if (adapter.getCellRenderer() != null) {
                col.setCellRenderer(this.createCellRenderer(adapter));
            }
            if (adapter.getMaxWidth() == null) continue;
            col.setPreferredWidth(adapter.getMaxWidth());
            col.setMaxWidth(adapter.getMaxWidth());
        }
    }

    private TableCellEditor createCellEditor(ITableAdapter adapter) {
        try {
            return adapter.getCellEditor().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e2) {
            throw Check.fail(e2);
        }
    }

    private TableCellRenderer createCellRenderer(ITableAdapter adapter) {
        try {
            return adapter.getCellRenderer().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e2) {
            throw Check.fail(e2);
        }
    }

    private void registerRenderers() {
        this.table.addHighlighter(new ErrorHighlighter());
        this.table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer());
        this.table.setDefaultRenderer(DeleteButton.class, new DeleteButtonRenderer());
        this.table.setDefaultRenderer(BooleanNode.class, new BooleanRenderer());
        this.table.setDefaultRenderer(SelectionNode.class, new SelectionCellRenderer());
        this.table.setDefaultRenderer(DecimalNode.class, new DecimalRenderer());
        this.table.setDefaultRenderer(IntegralNode.class, new IntegralRenderer());
    }

    private void registerEditors() {
        this.table.setDefaultEditor(StringNode.class, new StringCellEditor());
        this.table.setDefaultEditor(SelectionNode.class, new SelectionCellEditor());
        this.table.setDefaultEditor(IntegralNode.class, new IntegralCellEditor());
        this.table.setDefaultEditor(DecimalNode.class, new DecimalCellEditor());
        this.table.setDefaultEditor(DateNode.class, new DateCellEditor());
        this.table.setDefaultEditor(BooleanNode.class, new BooleanCellEditor());
    }

    public void setFocus(int cell) {
        this.table.changeSelection(0, cell, false, false);
        this.table.requestFocusInWindow();
    }

    public void stopEditing() {
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().stopCellEditing();
        }
    }

    public void selectFirstRow() {
        this.table.getSelectionModel().setSelectionInterval(0, 0);
    }

    public void repairFocus() {
        this.table.requestFocusInWindow();
        if (this.tablePm.getRowCount() > 1) {
            return;
        }
        this.table.changeSelection(0, 0, false, false);
    }

    private void scrollToRow(int rowIndex) {
        Rectangle rect = this.table.getCellRect(rowIndex, 1, true);
        rect = new Rectangle(rect.x, rect.y - 20, rect.width, rect.height + 40);
        this.table.scrollRectToVisible(rect);
    }

    public void setDefaultRenderer(Class<?> columnClass, TableCellRenderer renderer) {
        this.table.setDefaultRenderer(columnClass, renderer);
    }

    public void setDefaultEditor(Class<?> columnClass, TableCellEditor editor) {
        this.table.setDefaultEditor(columnClass, editor);
    }
}

