/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.control.table;

import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTableHeader;

public class ToolTipJXTable
extends JXTable {
    public ToolTipJXTable() {
    }

    public ToolTipJXTable(TableModel pm) {
        super(pm);
    }

    @Override
    public String getToolTipText(MouseEvent e2) {
        String toolTipText = null;
        Point mousePoint = e2.getPoint();
        int row = this.rowAtPoint(mousePoint);
        int col = this.columnAtPoint(mousePoint);
        if (row < 0 || col < 0) {
            return null;
        }
        int actualWidth = this.getCellRect((int)row, (int)col, (boolean)false).width;
        int preferredWidth = this.prepareRenderer((TableCellRenderer)this.getCellRenderer((int)row, (int)col), (int)row, (int)col).getPreferredSize().width;
        if (actualWidth < preferredWidth) {
            Object cellValue = this.getValueAt(row, col);
            toolTipText = cellValue != null ? cellValue.toString() : null;
        }
        return toolTipText != null && toolTipText.isBlank() ? null : toolTipText;
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JXTableHeader(this.columnModel){

            @Override
            public String getToolTipText(MouseEvent e2) {
                String toolTipText = null;
                Point p = e2.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                if (index < 0) {
                    return null;
                }
                int actualWidth = this.getHeaderRect((int)index).width;
                TableColumn tableColumn = this.columnModel.getColumn(index);
                TableCellRenderer renderer = tableColumn.getHeaderRenderer();
                Object headerValue = tableColumn.getHeaderValue();
                renderer = renderer == null ? ToolTipJXTable.this.getTableHeader().getDefaultRenderer() : renderer;
                int preferredWidth = renderer.getTableCellRendererComponent((JTable)this.table, (Object)headerValue, (boolean)false, (boolean)false, (int)-1, (int)index).getPreferredSize().width;
                if (actualWidth < preferredWidth) {
                    toolTipText = headerValue != null ? headerValue.toString() : null;
                }
                return toolTipText != null && toolTipText.isBlank() ? null : toolTipText;
            }
        };
    }
}

