/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.control.tabs;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.gui.IGuiService;
import ch.transsoft.edec.service.validate.ErrorInfo;
import ch.transsoft.edec.ui.gui.Design;
import java.awt.Color;
import java.awt.Component;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class TabbedPane
extends JTabbedPane {
    private Set<Integer> markedTabs = new HashSet<Integer>();

    public TabbedPane() {
        super(1);
    }

    protected void init() {
        this.setColors();
        this.addTabListener();
    }

    public void setColors() {
        for (int i2 = 0; i2 < this.getTabCount(); ++i2) {
            this.setBackgroundAt(i2, this.getBgColor(i2));
        }
        this.updateTabColor();
    }

    private void addTabListener() {
        this.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e2) {
                Services.get(IGuiService.class).commitCurrentEditor();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TabbedPane.this.updateTabColor();
                    }
                });
            }
        });
        this.updateTabColor();
    }

    public void setError(int tabIndex, ErrorInfo errorInfo) {
        this.setToolTipTextAt(tabIndex, errorInfo.getMesage());
        this.markedTabs.add(tabIndex);
        this.setBackgroundAt(tabIndex, Design.ERROR_COLOR);
        this.updateTabColor();
    }

    public void removeError(int tabIndex) {
        this.setToolTipTextAt(tabIndex, null);
        this.markedTabs.remove(tabIndex);
        this.setBackgroundAt(tabIndex, this.getBgColor(tabIndex));
        this.updateTabColor();
    }

    private void updateTabColor() {
        int index = this.getSelectedIndex();
        if (index == -1) {
            return;
        }
        UIManager.put("TabbedPane.selected", this.markedTabs.contains(index) ? Design.ERROR_SELECTED_COLOR : this.getSelectedColor(index));
        this.updateUI();
    }

    protected abstract Color getSelectedColor(int var1);

    private Color getBgColor(int index) {
        if (this.markedTabs.contains(index)) {
            return Design.ERROR_COLOR;
        }
        return this.getBackgroundColor(index);
    }

    protected abstract Color getBackgroundColor(int var1);

    public void removeAllErrors() {
        this.markedTabs.clear();
        for (int i2 = 0; i2 < this.getTabCount(); ++i2) {
            this.removeError(i2);
        }
    }

    @Override
    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        super.insertTab(title, icon, component, tip, index);
        this.setBackgroundAt(index, this.getBgColor(index));
    }
}

