/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.evvimport.receipt;

import ch.transsoft.edec.model.evvimport.receipt.ReceiptEntry;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.backend.jobs.evvimport.receipt.UpdateStarJob;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.config.IConfigServiceListener;
import ch.transsoft.edec.service.ezv.ReceiptDocumentType;
import ch.transsoft.edec.service.gui.IGuiService;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.ui.gui.control.searchtable.SearchTable;
import ch.transsoft.edec.ui.gui.evvimport.receipt.IReceiptPopupMenuHandler;
import ch.transsoft.edec.ui.gui.evvimport.receipt.ReceiptDocRenderer;
import ch.transsoft.edec.ui.gui.evvimport.receipt.StarRenderer;
import ch.transsoft.edec.ui.gui.sendinglist.DecimalNodeComparator;
import ch.transsoft.edec.ui.gui.sendinglist.EdecDateNodeComparator;
import ch.transsoft.edec.ui.pm.evvimport.receipt.ReceiptIndexTablePmBase;
import ch.transsoft.edec.ui.pm.sendinglist.IIndexTablePmListener;
import ch.transsoft.edec.util.DocumentUtil;
import ch.transsoft.edec.util.TableUtil;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.decorator.SortOrder;

public class ReceiptIndexTablePanel
extends JScrollPane {
    private SearchTable table;
    private final ReceiptIndexTablePmBase pm;
    private final IReceiptPopupMenuHandler receiptPopupMenuHandler;

    public ReceiptIndexTablePanel(ReceiptIndexTablePmBase pm, IReceiptPopupMenuHandler receiptPopupMenuHandler) {
        this.pm = pm;
        this.receiptPopupMenuHandler = receiptPopupMenuHandler;
        this.table = new SearchTable((TableModel)pm, true);
        pm.setSelectionModel(this.table.getSelectionModel());
        this.setViewportView(this.table);
        this.table.enableFiltering(true);
        this.configureTableUI();
        this.addMouseListener();
        this.addPmListener();
        this.addActionListener();
        TableUtil.enableRightMouseButtonSelection(this.table);
        this.addPopupMenu();
        this.addRootChangedListener();
    }

    private void addRootChangedListener() {
        Services.get(IConfigService.class).add(new IConfigServiceListener(){

            @Override
            public void configurationChanged() {
                this.updateTable();
            }

            @Override
            public void rootChanged() {
                this.updateTable();
            }

            private void updateTable() {
                ReceiptIndexTablePanel.this.pm.fireTableStructureChanged();
                ReceiptIndexTablePanel.this.configureTableUI();
            }

            @Override
            public void modeChanged(boolean isDemo) {
            }
        });
    }

    private void configureTableUI() {
        this.table.setRowHeight(25);
        if (this.pm.idIsVisible(1)) {
            this.setAbsoluteWith(this.table.getColumn(this.pm.translateIdToColIndex(1)), 30);
            this.table.getColumnExt(this.pm.translateIdToColIndex(1)).setSortable(false);
            this.table.getColumn(this.pm.translateIdToColIndex(1)).setCellRenderer(new ReceiptDocRenderer(ReceiptDocumentType.vvm));
        }
        if (this.pm.idIsVisible(2)) {
            this.setAbsoluteWith(this.table.getColumn(this.pm.translateIdToColIndex(2)), 30);
            this.table.getColumnExt(this.pm.translateIdToColIndex(2)).setSortable(false);
            this.table.getColumn(this.pm.translateIdToColIndex(2)).setCellRenderer(new ReceiptDocRenderer(ReceiptDocumentType.vvz));
        }
        if (this.pm.idIsVisible(3)) {
            this.setAbsoluteWith(this.table.getColumn(this.pm.translateIdToColIndex(3)), 30);
            this.table.getColumnExt(this.pm.translateIdToColIndex(3)).setSortable(false);
            this.table.getColumn(this.pm.translateIdToColIndex(3)).setCellRenderer(new ReceiptDocRenderer(ReceiptDocumentType.rbz));
        }
        if (this.pm.idIsVisible(4)) {
            this.setAbsoluteWith(this.table.getColumn(3), 30);
            this.table.getColumnExt(this.pm.translateIdToColIndex(4)).setSortable(false);
            this.table.getColumn(this.pm.translateIdToColIndex(4)).setCellRenderer(new ReceiptDocRenderer(ReceiptDocumentType.rbm));
        }
        if (this.pm.idIsVisible(5)) {
            this.table.getColumnExt(this.pm.translateIdToColIndex(5)).setComparator(new EdecDateNodeComparator());
            this.table.setSortOrder(this.pm.translateIdToColIndex(5), SortOrder.DESCENDING);
        }
        if (this.pm.idIsVisible(12)) {
            this.setAbsoluteWith(this.table.getColumn(this.pm.translateIdToColIndex(12)), 40);
        }
        if (this.pm.idIsVisible(13)) {
            this.setAbsoluteWith(this.table.getColumn(this.pm.translateIdToColIndex(13)), 70);
            this.table.getColumnExt(this.pm.translateIdToColIndex(13)).setComparator(new DecimalNodeComparator());
        }
        if (this.pm.idIsVisible(14)) {
            this.setAbsoluteWith(this.table.getColumn(this.pm.translateIdToColIndex(14)), 70);
            this.table.getColumnExt(this.pm.translateIdToColIndex(14)).setComparator(new DecimalNodeComparator());
        }
        if (this.pm.idIsVisible(20)) {
            this.setAbsoluteWith(this.table.getColumn(this.pm.translateIdToColIndex(20)), 60);
        }
        if (this.pm.idIsVisible(17)) {
            this.setAbsoluteWith(this.table.getColumn(this.pm.translateIdToColIndex(17)), 40);
        }
        if (this.pm.idIsVisible(27)) {
            this.setAbsoluteWith(this.table.getColumn(this.pm.translateIdToColIndex(27)), 30);
            this.table.getColumnExt(this.pm.translateIdToColIndex(27)).setToolTipText(Services.getText(1491));
            this.table.getColumn(this.pm.translateIdToColIndex(27)).setCellRenderer(new StarRenderer());
        }
    }

    private void setAbsoluteWith(TableColumn column, int with) {
        column.setMinWidth(with);
        column.setMaxWidth(with);
    }

    private void addActionListener() {
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e2) {
                if (!ReceiptIndexTablePanel.this.table.hasSelectedRow()) {
                    return;
                }
                if (e2.getKeyChar() != '\n') {
                    return;
                }
                e2.consume();
            }
        });
    }

    private void addPopupMenu() {
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e2) {
                if (e2.getButton() == 3) {
                    ReceiptIndexTablePanel.this.showMenu(e2);
                }
            }
        });
    }

    private void showMenu(MouseEvent e2) {
        int[] selectionIndices = this.table.getSelectionIndices();
        if (selectionIndices.length == 0) {
            return;
        }
        ArrayList<ReceiptEntry> selection = new ArrayList<ReceiptEntry>(selectionIndices.length);
        for (int index : selectionIndices) {
            selection.add(this.pm.getIndexEntry(index));
        }
        JPopupMenu menu = new JPopupMenu();
        this.receiptPopupMenuHandler.addItems(selection, menu);
        if (menu.getComponentCount() == 0) {
            return;
        }
        try {
            menu.show(e2.getComponent(), e2.getX(), e2.getY());
        }
        catch (Exception ex) {
            Services.get(ILoggingService.class).logSilentWithBugMail(ex, "IndexTablePanel.showMenu threw.");
        }
    }

    private void addPmListener() {
        this.pm.add(new IIndexTablePmListener(){

            @Override
            public void searchTextChanged(String text) {
                ReceiptIndexTablePanel.this.table.searchTextChanged(text);
            }

            @Override
            public void searchNext(boolean backwards) {
                ReceiptIndexTablePanel.this.table.searchNext(backwards);
            }

            @Override
            public void openCurrentSending() {
                if (!ReceiptIndexTablePanel.this.table.hasSelectedRow()) {
                    return;
                }
            }
        });
    }

    private void addMouseListener() {
        this.table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e2) {
                if (ReceiptIndexTablePanel.this.hitsClickableElement(e2)) {
                    Services.get(IGuiService.class).setLinkCursor(true);
                } else {
                    Services.get(IGuiService.class).setLinkCursor(false);
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e2) {
                Services.get(IGuiService.class).setLinkCursor(false);
            }

            @Override
            public void mousePressed(MouseEvent e2) {
                if (e2.getButton() != 1) {
                    return;
                }
                if (!ReceiptIndexTablePanel.this.table.hasSelectedRow()) {
                    return;
                }
                int row = ReceiptIndexTablePanel.this.table.getSelectionIndex();
                if (e2.getClickCount() == 1) {
                    ReceiptIndexTablePanel.this.handleClick(row, e2);
                    return;
                }
            }
        });
    }

    private void handleClick(int row, MouseEvent e2) {
        if (e2.getComponent().getWidth() - e2.getX() < 30) {
            ReceiptEntry entry = this.pm.getIndexEntry(row);
            Services.get(IBackendService.class).put(new UpdateStarJob(entry));
            return;
        }
        if (e2.getX() > 120) {
            return;
        }
        ReceiptEntry entry = this.pm.getIndexEntry(row);
        if (e2.getX() < 30) {
            if (!entry.hasVvmInfo()) {
                return;
            }
            DocumentUtil.showReceipt(entry, ReceiptDocumentType.vvm);
        } else if (e2.getX() < 60) {
            if (!entry.hasVvzInfo()) {
                return;
            }
            DocumentUtil.showReceipt(entry, ReceiptDocumentType.vvz);
        } else if (e2.getX() < 90) {
            if (!entry.hasRbmInfo()) {
                return;
            }
            DocumentUtil.showReceipt(entry, ReceiptDocumentType.rbm);
        } else if (e2.getX() < 120) {
            if (!entry.hasRbzInfo()) {
                return;
            }
            DocumentUtil.showReceipt(entry, ReceiptDocumentType.rbz);
        }
    }

    private boolean hitsClickableElement(MouseEvent e2) {
        if (e2.getComponent().getWidth() - e2.getX() < 30) {
            return true;
        }
        if (e2.getX() > 120) {
            return false;
        }
        int rowAtPoint = this.table.rowAtPoint(e2.getPoint());
        if (rowAtPoint == -1) {
            return false;
        }
        int row = this.table.convertRowIndexToModel(rowAtPoint);
        ReceiptEntry entry = this.pm.getIndexEntry(row);
        if (e2.getX() < 30) {
            return entry.hasVvmInfo();
        }
        if (e2.getX() < 60) {
            return entry.hasVvzInfo();
        }
        if (e2.getX() < 90) {
            return entry.hasRbmInfo();
        }
        if (e2.getX() < 120) {
            return entry.hasRbzInfo();
        }
        return false;
    }
}

