/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.evvimport.receipt;

import ch.transsoft.edec.model.infra.node.BooleanNode;
import ch.transsoft.edec.ui.img.IconLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class StarRenderer
extends JComponent
implements TableCellRenderer {
    private static ImageIcon star_gold = IconLoader.getIcon("icon/star_16.png");
    private static ImageIcon star_gray = IconLoader.getIcon("icon/star_gray_16.png");
    private static final int ICON_HEIGHT = 16;
    public static final int ICON_RIGHT = 4;
    public static final int COL_WIDTH = 30;
    private boolean value;
    private Color bgColor = Color.WHITE;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            return this;
        }
        BooleanNode node = (BooleanNode)value;
        this.value = node.getValue();
        this.detectBackgroundColor(table, isSelected);
        return this;
    }

    private void detectBackgroundColor(JTable table, boolean isSelected) {
        Color selectionBackground = table.getSelectionBackground();
        Color background = table.getBackground();
        this.bgColor = isSelected ? selectionBackground : background;
    }

    @Override
    protected void paintComponent(Graphics g2) {
        Graphics2D g22 = (Graphics2D)g2;
        g2.setColor(this.bgColor);
        g2.fillRect(0, 0, 30, 25);
        this.drawIcon(g22, this.value ? star_gold : star_gray, 4);
    }

    private void drawIcon(Graphics2D g2, ImageIcon icon, int x) {
        icon.paintIcon(this, g2, x + 2, 4);
    }
}

