/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.evvimport.receipt.popupactions;

import ch.transsoft.edec.model.evvimport.receipt.ReceiptEntry;
import ch.transsoft.edec.model.infra.node.FileNode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.action.ActionBase;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.backend.jobs.evvimport.receipt.ExportImportSendingJob;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.util.FileChooserUtil;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;

public class ExportImportSendingAction
extends ActionBase {
    private final List<ReceiptEntry> entries;

    public ExportImportSendingAction(List<ReceiptEntry> entries) {
        super(Services.getText(1427), "icon/Folder-small.png", "icon/Folder-big.png");
        this.entries = entries;
        if (Services.get(IBackendService.class).isActionsLocked()) {
            this.setEnabled(false);
            this.setTooltip(Services.getText(4428));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        FileNode lastFolder = Services.get(IConfigService.class).getPreferences().getLastUsedFolders().getImportSendingExportFolder();
        File folder = FileChooserUtil.chooseFolder(lastFolder.getValue(), Services.getText(1463), Services.getText(1464));
        if (folder == null) {
            return;
        }
        lastFolder.setValue(folder);
        Services.get(IConfigService.class).savePreferences();
        Services.get(IBackendService.class).put(new ExportImportSendingJob(this.entries, folder));
    }
}

