/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.imp;

import ch.transsoft.edec.ui.gui.imp.ButtonPanel;
import ch.transsoft.edec.ui.pm.imp.SendingInfo;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;

class ButtonEditor
extends AbstractCellEditor
implements TableCellEditor {
    protected ButtonPanel panel = new ButtonPanel();
    private boolean isPushed;

    public ButtonEditor() {
        this.panel.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ButtonEditor.this.fireEditingStopped();
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        SendingInfo info = (SendingInfo)value;
        this.panel.setState(info);
        this.panel.setBackground(table.getSelectionBackground());
        this.panel.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        this.isPushed = true;
        return this.panel;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.isPushed) {
            // empty if block
        }
        this.isPushed = false;
        return new String();
    }

    @Override
    public boolean stopCellEditing() {
        this.isPushed = false;
        return super.stopCellEditing();
    }

    @Override
    protected void fireEditingStopped() {
        super.fireEditingStopped();
    }
}

