/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.imp;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.logging.LoggingService;
import ch.transsoft.edec.ui.dialog.DialogUtil;
import ch.transsoft.edec.ui.img.IconLoader;
import ch.transsoft.edec.ui.pm.imp.SendingInfo;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;

public class ButtonPanel
extends JPanel {
    private static final Icon ERROR = IconLoader.getIcon("icon/Error-small.png");
    private static final Icon INFO = IconLoader.getIcon("icon/Info-small.png");
    protected JButton button;
    private SendingInfo sendingInfo;

    public ButtonPanel() {
        this.setLayout(new MigLayout("fillx", "2[center]2", "1[]1"));
        this.button = new JButton();
        this.add((Component)this.button, "height 20!, width 20!");
        Icon icon = UIManager.getIcon("OptionPane.errorIcon");
        this.button.setIcon(icon);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ButtonPanel.this.showProblem();
            }
        });
    }

    private void showProblem() {
        if (this.sendingInfo.hasError()) {
            String message = Services.getText(1501) + "\n\n" + LoggingService.getExceptionMessage(this.sendingInfo.getException());
            DialogUtil.showErrorDialog(Services.getText(1502), message);
        } else if (this.sendingInfo.hasInfo()) {
            String message = Services.getText(1501) + "\n\n" + this.sendingInfo.getInfos();
            DialogUtil.showInfoDialog(Services.getText(1503), message);
        }
    }

    public JButton getButton() {
        return this.button;
    }

    public void setState(SendingInfo info) {
        this.sendingInfo = info;
        if (info.hasError()) {
            this.button.setVisible(true);
            this.button.setIcon(ERROR);
        } else if (info.hasInfo()) {
            this.button.setVisible(true);
            this.button.setIcon(INFO);
        } else {
            this.button.setVisible(false);
        }
    }
}

