/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.sending;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.app.IAppService;
import ch.transsoft.edec.service.validate.ErrorInfo;
import ch.transsoft.edec.service.validate.IValidateService;
import ch.transsoft.edec.ui.gui.control.DefaultPanel;
import ch.transsoft.edec.ui.gui.control.tabs.AppStateAwareTabPane;
import ch.transsoft.edec.ui.gui.control.tabs.DefaultColorStrategy;
import ch.transsoft.edec.ui.gui.control.tabs.TabbedPane;
import ch.transsoft.edec.ui.gui.sending.forms.FormsPanel;
import ch.transsoft.edec.ui.gui.sending.heading.HeadingPanel;
import ch.transsoft.edec.ui.gui.sending.itemlist.ItemListPanel;
import ch.transsoft.edec.ui.gui.sending.statusline.StatusLinePanel;
import ch.transsoft.edec.ui.img.IconLoader;
import ch.transsoft.edec.ui.pm.sending.SendingPm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class SendingPanel
extends DefaultPanel {
    private static final int HEADER_TAB = 0;
    private static final int ITEMS_TAB = 1;
    private static final int CUSTOMS_ITEMS_TAB = 2;
    private final SendingPm pm;
    private final TabbedPane tabs;
    private final DefaultPanel panelContainer;
    private final List<JComponent> panels = new ArrayList<JComponent>();

    public SendingPanel(SendingPm sendingPm) {
        this.pm = sendingPm;
        this.setLayout(new BorderLayout());
        this.panelContainer = new DefaultPanel();
        this.panelContainer.setLayout(new BorderLayout());
        this.tabs = this.createTabs();
        this.panels.add(new HeadingPanel(this.pm.getHeadingPm()));
        this.pm.getHeadingPm().updateState();
        this.panels.add(new ItemListPanel(this.pm.getItemListPm()));
        this.panels.add(new FormsPanel(this.pm.getFormsPm()));
        if (!this.pm.getCustomsItemListPm().isEmpty()) {
            this.addCustomsItemPanel();
        }
        this.addTabsListener();
        this.add((Component)new StatusLinePanel(sendingPm.getStatusLinePm(), this.tabs), "North");
        this.add(this.panelContainer);
        this.activateTab(0);
        this.addCustomsItemListListener();
        this.addErrorListener();
    }

    private void addCustomsItemListListener() {
        this.pm.addCustomsItemListListener((source, info) -> {
            this.pm.recreateCustomsItemListPm();
            this.addCustomsItemPanel();
            this.selectCustomsItemList();
        });
    }

    private void addCustomsItemPanel() {
        if (!this.hasCustomsItemTab()) {
            this.tabs.insertTab(Services.getText(1296), null, new JPanel(), null, 2);
        } else {
            this.panels.remove(2);
        }
        this.panels.add(2, new ItemListPanel(this.pm.getCustomsItemListPm()));
        this.pm.getCustomsItemListPm().add((ErrorInfo errorInfo) -> {
            if (errorInfo.hasError()) {
                this.tabs.setError(2, errorInfo);
            } else {
                this.tabs.removeError(2);
            }
        });
        if (this.pm.sendingHasError()) {
            this.tabs.removeError(2);
            Services.get(IValidateService.class).validate(false);
        }
    }

    private boolean hasCustomsItemTab() {
        return this.panels.size() == 4;
    }

    private void addTabsListener() {
        this.tabs.addChangeListener(e2 -> {
            Services.get(IAppService.class).getCurrentSending().applyDefaults();
            this.activateTab(this.tabs.getSelectedIndex());
        });
    }

    private void activateTab(int index) {
        this.panelContainer.removeAll();
        this.panelContainer.add(this.panels.get(index));
        if (this.panels.get(index) instanceof ItemListPanel) {
            ((ItemListPanel)this.panels.get(index)).repairFocus();
        }
        this.panelContainer.validate();
        this.panelContainer.repaint();
    }

    private TabbedPane createTabs() {
        AppStateAwareTabPane result = new AppStateAwareTabPane(this.pm.getDisposables(), new DefaultColorStrategy());
        result.addTab(Services.getText(1005), IconLoader.getIcon("icon/spacer-1x30.png"), new JPanel());
        result.addTab(Services.getText(1006), new JPanel());
        result.addTab(Services.getText(1004), new JPanel());
        return result;
    }

    private void addErrorListener() {
        this.pm.getItemListPm().add((ErrorInfo errorInfo) -> {
            if (errorInfo.hasError()) {
                this.tabs.setError(1, errorInfo);
            } else {
                this.tabs.removeError(1);
            }
        });
        this.pm.getHeadingPm().add((ErrorInfo errorInfo) -> {
            if (errorInfo.hasError()) {
                this.tabs.setError(0, errorInfo);
            } else {
                this.tabs.removeError(0);
            }
        });
        this.pm.getFormsPm().add((ErrorInfo errorInfo) -> {
            if (errorInfo.hasError()) {
                this.tabs.setError(this.getFormsTab(), errorInfo);
            } else {
                this.tabs.removeError(this.getFormsTab());
            }
        });
    }

    public void selectHeader() {
        this.tabs.setSelectedIndex(0);
    }

    public void selectItemList() {
        this.tabs.setSelectedIndex(1);
    }

    public void selectCustomsItemList() {
        this.tabs.setSelectedIndex(2);
    }

    public void selectForms() {
        this.tabs.setSelectedIndex(this.getFormsTab());
    }

    private int getFormsTab() {
        return this.panels.size() - 1;
    }
}

