/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.sending.forms;

import ch.transsoft.edec.model.infra.node.DateNode;
import ch.transsoft.edec.model.infra.node.DecimalNode;
import ch.transsoft.edec.model.infra.node.IPrimitive;
import ch.transsoft.edec.model.infra.node.IntegralNode;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.model.infra.node.StringNodeBase;
import ch.transsoft.edec.service.form.FormConst;
import ch.transsoft.edec.service.form.desc.NodeDesc;
import ch.transsoft.edec.service.form.render.DataContext;
import ch.transsoft.edec.service.form.render.IRenderContext;
import ch.transsoft.edec.service.form.render.IUnitConverter;
import ch.transsoft.edec.service.form.render.RenderContext;
import ch.transsoft.edec.service.form.render.UnitConverterBase;
import ch.transsoft.edec.ui.gui.control.DateField;
import ch.transsoft.edec.ui.gui.control.DecimalField;
import ch.transsoft.edec.ui.gui.control.DefaultPanel;
import ch.transsoft.edec.ui.gui.control.IntegralField;
import ch.transsoft.edec.ui.gui.control.StringArea;
import ch.transsoft.edec.ui.gui.control.StringField;
import ch.transsoft.edec.ui.gui.sending.forms.FormUiHandle;
import ch.transsoft.edec.ui.gui.sending.forms.PageRenderer;
import ch.transsoft.edec.ui.gui.sending.forms.UnitConverterFactory;
import ch.transsoft.edec.ui.pm.model.DatePm;
import ch.transsoft.edec.ui.pm.model.DecimalPm;
import ch.transsoft.edec.ui.pm.model.IntegralPm;
import ch.transsoft.edec.ui.pm.model.StringPm;
import ch.transsoft.edec.ui.pm.sending.forms.PagePm;
import ch.transsoft.edec.util.Check;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class PageContentPanel
extends DefaultPanel
implements FormUiHandle {
    private static final double SCALE = FormConst.SCALE_FACTOR;
    private final PagePm pagePm;
    private final FormUiHandle formUiHandle;

    public PageContentPanel(PagePm pagePm, FormUiHandle formUiHandle) {
        this.pagePm = pagePm;
        this.formUiHandle = formUiHandle;
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        this.setLayout(null);
        this.setPreferredSize(FormConst.getScaledDimension(pagePm.getZoomScale()));
        UnitConverterBase c2 = UnitConverterFactory.createFormConverter(pagePm::getZoomScale);
        this.createInputFields(c2);
        this.addControls(c2);
        this.addFormContent();
        this.addStaticControls(c2);
        this.addListener(pagePm);
    }

    private void addFormContent() {
        JPanel comp = new JPanel(){

            @Override
            protected void paintComponent(Graphics g2) {
                Graphics2D gNew = (Graphics2D)g2.create();
                gNew.scale(SCALE * PageContentPanel.this.pagePm.getZoomScale(), SCALE * PageContentPanel.this.pagePm.getZoomScale());
                UnitConverterFactory.setRenderingHints(gNew);
                IUnitConverter unitConverter = UnitConverterFactory.createPrintConverter();
                PageContentPanel.this.pagePm.render(new RenderContext(unitConverter, gNew, IRenderContext.Mode.screen));
                PageRenderer renderer = new PageRenderer(PageContentPanel.this.pagePm.getSending(), PageContentPanel.this.pagePm.getGoodsItems(), PageContentPanel.this.pagePm.getFormPage(), PageContentPanel.this.getDataContext(), unitConverter, gNew);
                renderer.render(gNew);
                gNew.dispose();
            }
        };
        comp.setSize(FormConst.getScaledDimension(this.pagePm.getZoomScale()));
        comp.setLocation(0, 0);
        comp.setOpaque(false);
        this.add(comp);
    }

    private void addControls(IUnitConverter c2) {
        this.pagePm.addControls(this, c2);
    }

    private void addStaticControls(IUnitConverter c2) {
        this.pagePm.addStaticControls(this, c2);
    }

    private void addListener(PagePm pagePm) {
        pagePm.add(this::repaint);
    }

    private void createInputFields(IUnitConverter c2) {
        for (NodeDesc desc : this.pagePm.getNodes()) {
            if (!desc.isEditable()) continue;
            this.addNode(desc, c2);
        }
    }

    private void addNode(NodeDesc desc, IUnitConverter c2) {
        JComponent field = this.createField(desc);
        field.setFont(c2.getFont(desc.getFontValue()));
        int fontHeight = c2.getFont(desc.getFontValue()).getSize();
        Long maxRows = desc.getHeight().getValue();
        long height = (long)((double)maxRows.longValue() * ((double)fontHeight * 1.25)) + 1L;
        field.setBounds(c2.px(desc.getX()), c2.py(desc.getY()) + 3, c2.px(desc.getWidth()), (int)height);
        this.add(field);
    }

    private JComponent createField(NodeDesc desc) {
        IPrimitive<?> node = desc.getPrimitive(this.pagePm.getSending());
        if (node instanceof StringNode) {
            return this.createTextField(desc, (StringNodeBase)node);
        }
        if (node instanceof IntegralNode) {
            return this.createIntegralField(node);
        }
        if (node instanceof DecimalNode) {
            return this.createDecimalField(node);
        }
        if (node instanceof DateNode) {
            return this.createDateField(node);
        }
        throw Check.fail("Unknown type:", node.getClass().getSimpleName());
    }

    private DateField createDateField(IPrimitive<?> node) {
        DatePm doc = new DatePm((DateNode)node);
        this.pagePm.addDisposable(doc);
        return new DateField(doc);
    }

    private DecimalField createDecimalField(IPrimitive<?> node) {
        DecimalPm doc = new DecimalPm((DecimalNode)node);
        this.pagePm.addDisposable(doc);
        return new DecimalField(doc);
    }

    private IntegralField createIntegralField(IPrimitive<?> node) {
        IntegralPm doc = new IntegralPm((IntegralNode)node);
        this.pagePm.addDisposable(doc);
        return new IntegralField(doc);
    }

    private JComponent createTextField(NodeDesc desc, StringNodeBase<?> node) {
        JComponent field = desc.getHeight().getValue() == 1L ? this.createStringField(node) : this.createStringArea(desc, node);
        return field;
    }

    private StringArea createStringArea(NodeDesc desc, StringNodeBase<?> node) {
        StringPm doc = new StringPm(node);
        this.pagePm.addDisposable(doc);
        return new StringArea(doc, desc.getHeight().getIntValue(), this.pagePm.getTextBackgroundColor());
    }

    private StringField createStringField(StringNodeBase<?> node) {
        StringPm doc = new StringPm(node);
        this.pagePm.addDisposable(doc);
        return new StringField(doc);
    }

    @Override
    public void reCreateUi() {
        this.formUiHandle.reCreateUi();
    }

    public DataContext getDataContext() {
        return this.pagePm.getDataContext();
    }
}

