/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.sending.forms;

import ch.transsoft.edec.ui.gui.control.DefaultPanel;
import ch.transsoft.edec.ui.gui.sending.forms.FormUiHandle;
import ch.transsoft.edec.ui.gui.sending.forms.PageContentWrapper;
import ch.transsoft.edec.ui.img.IconLoader;
import ch.transsoft.edec.ui.pm.sending.forms.PagePm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseWheelEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

public class PagePanel
extends DefaultPanel {
    private final PagePm pagePm;
    private final FormUiHandle formUiHandle;

    public PagePanel(PagePm pagePm, FormUiHandle formUiHandle) {
        this.pagePm = pagePm;
        this.formUiHandle = formUiHandle;
        this.setLayout(new BorderLayout());
        this.add(this.createPageContent(formUiHandle));
        this.add(this.createNavigation(), "South");
    }

    private Component createNavigation() {
        JPanel result = new JPanel();
        result.setLayout(new MigLayout("fill", "[center]", ""));
        JButton backButton = new JButton(IconLoader.getIcon("icon/arrow-left-small.png"));
        result.add((Component)backButton, "width 24!, height 22!, split 3");
        backButton.setModel(this.pagePm.getBackButtonModel());
        JTextField pageNumber = new JTextField();
        result.add((Component)pageNumber, "height 22!, width 40!");
        pageNumber.setEditable(false);
        pageNumber.setDocument(this.pagePm.getPageNumberModel());
        JButton forwardButton = new JButton(IconLoader.getIcon("icon/arrow-right-small.png"));
        result.add((Component)forwardButton, "width 24!, height 22!");
        forwardButton.setModel(this.pagePm.getForwardButtonModel());
        JSlider zoomSlider = new JSlider(this.pagePm.getZoomSliderModel());
        result.add(zoomSlider);
        zoomSlider.setMajorTickSpacing(50);
        zoomSlider.setMinorTickSpacing(10);
        zoomSlider.setSnapToTicks(true);
        zoomSlider.setPaintTicks(true);
        zoomSlider.setPaintLabels(true);
        return result;
    }

    private Component createPageContent(FormUiHandle formUiHandle) {
        JScrollPane result = new JScrollPane(20, 30){

            @Override
            protected void processMouseWheelEvent(MouseWheelEvent e2) {
                if (e2.isControlDown()) {
                    PagePanel.this.pagePm.adjustZoomByMouseWheel(e2);
                } else {
                    super.processMouseWheelEvent(e2);
                }
                e2.consume();
            }
        };
        result.setBorder(null);
        result.setViewportView(new PageContentWrapper(this.pagePm, formUiHandle));
        return result;
    }

    public void recreatePageContent() {
        for (Component c2 : this.getComponents()) {
            if (!(c2 instanceof JScrollPane)) continue;
            this.remove(c2);
        }
        this.add(this.createPageContent(this.formUiHandle));
        this.updateUI();
    }
}

