/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.sending.forms;

import ch.transsoft.edec.model.infra.node.DecimalNode;
import ch.transsoft.edec.service.form.desc.Fonts;
import ch.transsoft.edec.service.form.render.UnitConverterBase;
import ch.transsoft.edec.ui.gui.sending.forms.ZoomScaleProvider;
import ch.transsoft.edec.util.Check;
import java.awt.Font;

public class ScaleUnitConverter
extends UnitConverterBase {
    private final double scaleFactor;
    private final ZoomScaleProvider zoomFunction;
    private final UnitConverterBase unitConverter;

    ScaleUnitConverter(ZoomScaleProvider zoomFunction, double scaleFactor, UnitConverterBase unitConverter) {
        this.scaleFactor = scaleFactor;
        this.zoomFunction = zoomFunction;
        this.unitConverter = unitConverter;
    }

    private double getScaleAndZoomFactor() {
        return this.scaleFactor * this.zoomFunction.getValue();
    }

    @Override
    public int px(DecimalNode mm) {
        return (int)((double)this.unitConverter.px(mm) * this.getScaleAndZoomFactor());
    }

    @Override
    public int py(DecimalNode mm) {
        return (int)((double)this.unitConverter.py(mm) * this.getScaleAndZoomFactor());
    }

    @Override
    public int px(double mm) {
        return (int)((double)this.unitConverter.px(mm) * this.getScaleAndZoomFactor());
    }

    @Override
    public int py(double mm) {
        return (int)((double)this.unitConverter.py(mm) * this.getScaleAndZoomFactor());
    }

    @Override
    public double mmx(int px) {
        return this.unitConverter.mmx(px) / this.getScaleAndZoomFactor();
    }

    @Override
    public double mmy(int px) {
        return this.unitConverter.mmy(px) / this.getScaleAndZoomFactor();
    }

    @Override
    public Font getFont(Fonts font) {
        switch (font) {
            case font6: {
                return this.getFont(this.getFont6(), false);
            }
            case font6bold: {
                return this.getFont(this.getFont6(), true);
            }
            case font7: {
                return this.getFont(this.getFont7(), false);
            }
            case font7bold: {
                return this.getFont(this.getFont7(), true);
            }
            case font8: {
                return this.getFont(this.getFont8(), false);
            }
            case font8bold: {
                return this.getFont(this.getFont8(), true);
            }
            case font9: {
                return this.getFont(this.getFont9(), false);
            }
            case font9bold: {
                return this.getFont(this.getFont9(), true);
            }
            case font10: {
                return this.getFont(this.getFont10(), false);
            }
            case font10bold: {
                return this.getFont(this.getFont10(), true);
            }
            case font11: {
                return this.getFont(this.getFont11(), false);
            }
            case font11bold: {
                return this.getFont(this.getFont11(), true);
            }
            case font12: {
                return this.getFont(this.getFont12(), false);
            }
            case font12bold: {
                return this.getFont(this.getFont12(), true);
            }
            case font14bold: {
                return this.getFont(this.getFont14(), true);
            }
            case font20bold: {
                return this.getFont(this.getFont20(), true);
            }
        }
        throw Check.fail("Unknown font: " + String.valueOf((Object)font));
    }

    @Override
    public double getZoom() {
        return this.zoomFunction.getValue();
    }

    @Override
    public int getFont6() {
        return this.scaleFont(this.unitConverter.getFont6());
    }

    @Override
    public int getFont7() {
        return this.scaleFont(this.unitConverter.getFont7());
    }

    @Override
    public int getFont8() {
        return this.scaleFont(this.unitConverter.getFont8());
    }

    @Override
    public int getFont9() {
        return this.scaleFont(this.unitConverter.getFont9());
    }

    @Override
    public int getFont10() {
        return this.scaleFont(this.unitConverter.getFont10());
    }

    @Override
    public int getFont11() {
        return this.scaleFont(this.unitConverter.getFont11());
    }

    @Override
    public int getFont12() {
        return this.scaleFont(this.unitConverter.getFont12());
    }

    @Override
    public int getFont14() {
        return this.scaleFont(this.unitConverter.getFont14());
    }

    @Override
    public int getFont20() {
        return this.scaleFont(this.unitConverter.getFont20());
    }

    private int scaleFont(int fontSize) {
        return (int)Math.round((double)fontSize * this.getScaleAndZoomFactor());
    }
}

