/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.sending.heading;

import ch.transsoft.edec.model.infra.NodeFactory;
import ch.transsoft.edec.model.masterdata.Carriers;
import ch.transsoft.edec.model.sending.goodsdeclaration.Carrier;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.masterdata.DataFiles;
import ch.transsoft.edec.service.masterdataezv.DomainValue;
import ch.transsoft.edec.ui.dialog.DialogUtil;
import ch.transsoft.edec.ui.dialog.insert.IInsertDialogTrait;
import ch.transsoft.edec.ui.dialog.insert.InsertDialog;
import ch.transsoft.edec.ui.gui.control.AddButton;
import ch.transsoft.edec.ui.gui.control.DefaultPanel;
import ch.transsoft.edec.ui.gui.control.DeleteButton;
import ch.transsoft.edec.ui.gui.control.InfoIcon;
import ch.transsoft.edec.ui.gui.control.Label;
import ch.transsoft.edec.ui.gui.control.StringField;
import ch.transsoft.edec.ui.gui.control.ZoomInButton;
import ch.transsoft.edec.ui.gui.control.combo.SelectionField;
import ch.transsoft.edec.ui.gui.sending.heading.dialog.ZoomCarrierDialog;
import ch.transsoft.edec.ui.pm.sending.heading.CarrierPm;
import java.awt.Component;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

public class CarrierPanel
extends DefaultPanel {
    private final CarrierPm carrierPm;
    private AddButton addButton;
    private ZoomInButton zoomButton;
    private DeleteButton deleteButton;

    public CarrierPanel(CarrierPm carrierPm) {
        this.carrierPm = carrierPm;
        this.setBorder(new TitledBorder(Services.getText(1113)));
        this.setLayout(new MigLayout("fillx", "[right, 70::][left, fill, grow][left, 30px!]", "[]3[]"));
        this.createButtons();
        this.add(new Label(this.getText(500)));
        this.add((Component)new StringField(carrierPm.getName()), "grow, height 20!");
        this.add((Component)this.addButton, "width 20!, height 20!, wrap");
        this.add(new Label(this.getText(501)));
        this.add((Component)new StringField(carrierPm.getStreet()), "grow, height 20!");
        this.add((Component)this.zoomButton, "width 20!, height 20!, wrap");
        this.add(new Label(this.getText(503)));
        this.add((Component)new StringField(carrierPm.getPostalCode()), ", height 20!,split 2, width 80px!");
        this.add((Component)new StringField(carrierPm.getCity()), "grow, width 60::, height 20!");
        this.add((Component)this.deleteButton, "width 20!, height 20!, wrap");
        this.add(new Label(this.getText(504)));
        this.add(new SelectionField<DomainValue>(carrierPm.getCountry()), "grow, width 100::, height 20!");
        this.add((Component)new InfoIcon(), "wrap");
        this.add(new Label(Services.getText(511)));
        this.add((Component)new StringField(carrierPm.getEmail()), "grow, height 20!");
        this.add((Component)new InfoIcon(), "wrap");
    }

    private void createButtons() {
        this.addButton = new AddButton();
        this.addButton.setToolTipText(Services.format(1153, 1110));
        this.addAddButtonListener();
        this.zoomButton = new ZoomInButton();
        this.zoomButton.setToolTipText(Services.getText(1154));
        this.addZoomButtonListener();
        this.deleteButton = new DeleteButton();
        this.deleteButton.setToolTipText(Services.format(1164, 1409));
        this.addDeleteButtonListener();
    }

    public void addZoomButtonListener() {
        this.zoomButton.addActionListener(e2 -> this.zoomConsignor());
    }

    private void zoomConsignor() {
        ZoomCarrierDialog dialog = new ZoomCarrierDialog();
        DialogUtil.centerDialog(dialog, 500, 400);
        dialog.setVisible(true);
    }

    private void addAddButtonListener() {
        this.addButton.addActionListener(e2 -> {
            IInsertDialogTrait trait = Carriers::getCarrierList;
            new InsertDialog<Carrier, Carriers>(Services.getText(1113), this.addButton, trait, DataFiles.carrier, Carrier.tableConfig, this.carrierPm::apply).setVisible(true);
        });
    }

    private void addDeleteButtonListener() {
        this.deleteButton.addActionListener(e2 -> this.carrierPm.apply(NodeFactory.create(Carrier.class)));
    }
}

