/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.sending.itemlist;

import ch.transsoft.edec.model.infra.IErrorListener;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.validate.ErrorInfo;
import ch.transsoft.edec.ui.gui.control.tabs.SimpleTabbedPane;
import ch.transsoft.edec.ui.gui.sending.itemlist.ConfirmationTab;
import ch.transsoft.edec.ui.gui.sending.itemlist.GoodsDataTab;
import ch.transsoft.edec.ui.gui.sending.itemlist.GoodsItemDetailTab;
import ch.transsoft.edec.ui.gui.sending.itemlist.NonCustomsLawTab;
import ch.transsoft.edec.ui.gui.sending.itemlist.NotificationsTab;
import ch.transsoft.edec.ui.gui.sending.itemlist.PermitsTab;
import ch.transsoft.edec.ui.gui.sending.itemlist.ProducedDocumentsTab;
import ch.transsoft.edec.ui.gui.sending.itemlist.RepairAndRefinementTab;
import ch.transsoft.edec.ui.gui.sending.itemlist.SensibleGoodsTab;
import ch.transsoft.edec.ui.gui.sending.itemlist.SpecialMentionsTab;
import ch.transsoft.edec.ui.pm.sending.itemlist.DetailContainerPm;
import ch.transsoft.edec.ui.pm.sending.itemlist.GoodsItemPm;
import java.awt.Dimension;

public class GoodsItemPanel
extends SimpleTabbedPane
implements DetailContainerPm.ISelectionChangeListener {
    private GoodsItemPm pm;
    private GoodsDataTab goodsDataTab;
    private ProducedDocumentsTab producedDocsTab;
    private PermitsTab permitsTab;
    private NotificationsTab notificationsTab;
    private SpecialMentionsTab specialMentionsTab;
    private SensibleGoodsTab sensibleGoodsTab;
    private NonCustomsLawTab nonCustomsLawTab;
    private GoodsItemDetailTab goodsItemDetailTab;
    private RepairAndRefinementTab repairAndRefinementTab;
    private ConfirmationTab confirmationTab;
    private static final int goodsData_pos = 0;
    private static final int producedDocuments_pos = 1;
    private static final int permits_pos = 2;
    private static final int notifications_pos = 3;
    private static final int specialMentions_pos = 4;
    private static final int sensibleGoods_pos = 5;
    private static final int nonCustomsLaw_pos = 6;
    private static final int goodsItemDetail_pos = 7;
    private static final int repairAndRefinement_pos = 8;
    private static final int confirmation_pos = 9;
    private final boolean isMasterdata;

    public GoodsItemPanel() {
        this(true);
    }

    public GoodsItemPanel(boolean isMasterdata) {
        this.isMasterdata = isMasterdata;
        this.goodsDataTab = new GoodsDataTab();
        this.addTab(Services.getText(1270), this.goodsDataTab);
        this.producedDocsTab = new ProducedDocumentsTab();
        this.addTab(Services.getText(1271), this.producedDocsTab);
        this.permitsTab = new PermitsTab();
        this.addTab(Services.getText(1272), this.permitsTab);
        this.notificationsTab = new NotificationsTab();
        this.addTab(Services.getText(1273), this.notificationsTab);
        this.specialMentionsTab = new SpecialMentionsTab();
        this.addTab(Services.getText(1293), this.specialMentionsTab);
        this.sensibleGoodsTab = new SensibleGoodsTab();
        this.addTab(Services.getText(1274), this.sensibleGoodsTab);
        this.nonCustomsLawTab = new NonCustomsLawTab();
        this.addTab(Services.getText(1275), this.nonCustomsLawTab);
        this.goodsItemDetailTab = new GoodsItemDetailTab();
        this.addTab(Services.getText(1276), this.goodsItemDetailTab);
        this.repairAndRefinementTab = new RepairAndRefinementTab();
        this.addTab(Services.getText(1277), this.repairAndRefinementTab);
        this.confirmationTab = new ConfirmationTab();
        this.addTab(Services.getText(1278), this.confirmationTab);
        this.setMaximumSize(new Dimension(100, 100));
    }

    @Override
    public void selectionChanged(GoodsItemPm pm) {
        this.setModel(pm);
    }

    public void setModel(GoodsItemPm pm) {
        this.pm = pm;
        this.addErrorListener();
        this.setErrors();
        this.goodsDataTab.setModel(pm.getGoodsDataPm());
        this.producedDocsTab.setModel(pm.getProducedDocumentPm());
        this.permitsTab.setModel(pm.getPermitPm());
        this.notificationsTab.setModel(pm.getNotificationPm());
        this.specialMentionsTab.setModel(pm.getSpecialMentionPm());
        this.sensibleGoodsTab.setModel(pm.getSensibleGoodsPm());
        this.repairAndRefinementTab.setModel(pm.getRepairAndRefinementPm());
        this.nonCustomsLawTab.setModel(pm.getNonCustomsLawPm());
        this.goodsItemDetailTab.setModel(pm.getGoodsItemDetailPm());
        this.confirmationTab.setModel(pm.getConfirmationPm());
    }

    private void setErrors() {
        this.setErrors(0, this.pm.getGoodsDataPm().getErrorInfo());
        this.setErrors(1, this.pm.getProducedDocumentPm().getErrorInfo());
        this.setErrors(2, this.pm.getPermitPm().getErrorInfo());
        this.setErrors(3, this.pm.getNotificationPm().getErrorInfo());
        this.setErrors(4, this.pm.getSpecialMentionPm().getErrorInfo());
        this.setErrors(5, this.pm.getSensibleGoodsPm().getErrorInfo());
        this.setErrors(7, this.pm.getGoodsItemDetailPm().getErrorInfo());
        this.setErrors(6, this.pm.getNonCustomsLawPm().getErrorInfo());
        this.setErrors(8, this.pm.getRepairAndRefinementPm().getErrorInfo());
        this.setErrors(9, this.pm.getConfirmationPm().getErrorInfo());
    }

    private void addErrorListener() {
        this.pm.getGoodsDataPm().add(new IErrorListener(){

            @Override
            public void change(ErrorInfo errorInfo) {
                GoodsItemPanel.this.setErrors(0, errorInfo);
            }
        });
        this.pm.getProducedDocumentPm().add(new IErrorListener(){

            @Override
            public void change(ErrorInfo errorInfo) {
                GoodsItemPanel.this.setErrors(1, errorInfo);
            }
        });
        this.pm.getPermitPm().add(new IErrorListener(){

            @Override
            public void change(ErrorInfo errorInfo) {
                GoodsItemPanel.this.setErrors(2, errorInfo);
            }
        });
        this.pm.getNotificationPm().add(new IErrorListener(){

            @Override
            public void change(ErrorInfo errorInfo) {
                GoodsItemPanel.this.setErrors(3, errorInfo);
            }
        });
        this.pm.getSpecialMentionPm().add(new IErrorListener(){

            @Override
            public void change(ErrorInfo errorInfo) {
                GoodsItemPanel.this.setErrors(4, errorInfo);
            }
        });
        this.pm.getSensibleGoodsPm().add(new IErrorListener(){

            @Override
            public void change(ErrorInfo errorInfo) {
                GoodsItemPanel.this.setErrors(5, errorInfo);
            }
        });
        this.pm.getRepairAndRefinementPm().add(new IErrorListener(){

            @Override
            public void change(ErrorInfo errorInfo) {
                GoodsItemPanel.this.setErrors(8, errorInfo);
            }
        });
        this.pm.getConfirmationPm().add(new IErrorListener(){

            @Override
            public void change(ErrorInfo errorInfo) {
                GoodsItemPanel.this.setErrors(9, errorInfo);
            }
        });
        this.pm.getNonCustomsLawPm().add(new IErrorListener(){

            @Override
            public void change(ErrorInfo errorInfo) {
                GoodsItemPanel.this.setErrors(6, errorInfo);
            }
        });
        this.pm.getGoodsItemDetailPm().add(new IErrorListener(){

            @Override
            public void change(ErrorInfo errorInfo) {
                GoodsItemPanel.this.setErrors(7, errorInfo);
            }
        });
    }

    private void setErrors(int index, ErrorInfo errorInfo) {
        if (errorInfo.hasError()) {
            this.setError(index, errorInfo);
        } else {
            this.removeError(index);
        }
    }
}

