/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.sending.statusline;

import ch.transsoft.edec.model.infra.event.IChangeInfo;
import ch.transsoft.edec.model.infra.node.INode;
import ch.transsoft.edec.model.sending.ALState;
import ch.transsoft.edec.model.sending.EVVState;
import ch.transsoft.edec.model.sending.InternalState;
import ch.transsoft.edec.model.sending.OperatingMode;
import ch.transsoft.edec.model.sending.State;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.gui.IGuiService;
import ch.transsoft.edec.ui.gui.Design;
import ch.transsoft.edec.ui.gui.control.DefaultPanel;
import ch.transsoft.edec.ui.gui.sending.statusline.popmenu.DownloadAlAgainAction;
import ch.transsoft.edec.ui.gui.sending.statusline.popmenu.GetEvvAction;
import ch.transsoft.edec.ui.gui.sending.statusline.popmenu.SpediteurAction;
import ch.transsoft.edec.ui.img.IconLoader;
import ch.transsoft.edec.ui.pm.sending.statusline.SendingStatePm;
import ch.transsoft.edec.util.DocumentUtil;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class SendingStateDisplay
extends DefaultPanel {
    private static final ImageIcon check = IconLoader.getIcon("icon/Check-green-24x24.png");
    private static final ImageIcon pdf = IconLoader.getIcon("icon/pdf-24x24.png");
    private static final ImageIcon evv_mailed = IconLoader.getIcon("icon/evv_mailed-24x24.png");
    private static final ImageIcon truck = IconLoader.getIcon("icon/Truck-24x24.png");
    private static final ImageIcon error = IconLoader.getIcon("icon/Error-24x24.png");
    private static final ImageIcon test = IconLoader.getIcon("icon/test-7x26.png");
    private static final ImageIcon point_green = IconLoader.getIcon("icon/Point-green-24x24.png");
    private static final int ICON_HEIGHT = 24;
    public static final int AL_POS = 12;
    public static final int INTERNAL_POS = 45;
    public static final int EVV_POS = 78;
    private final State state;
    private final SendingStatePm pm;

    public SendingStateDisplay(SendingStatePm pm) {
        this.pm = pm;
        this.state = pm.getSending().getState();
        this.addPmListener();
        this.addMouseListener();
    }

    private void addMouseListener() {
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e2) {
                this.setToolTip(e2);
                Services.get(IGuiService.class).setLinkCursor(this.hitsClickablePoint(e2));
            }

            private boolean hitsClickablePoint(MouseEvent e2) {
                if (e2.getX() < 45) {
                    return SendingStateDisplay.this.pm.getSending().getState().hasAl();
                }
                if (e2.getX() > 78) {
                    return SendingStateDisplay.this.pm.getSending().getState().hasEvv();
                }
                return true;
            }

            private void setToolTip(MouseEvent e2) {
                if (e2.getX() < 45) {
                    SendingStateDisplay.this.setToolTipText(Services.getText(774));
                } else if (e2.getX() > 78) {
                    if (SendingStateDisplay.this.state.hasEvv()) {
                        SendingStateDisplay.this.setToolTipText(Services.getText(1513));
                    } else if (SendingStateDisplay.this.state.isSelectedState()) {
                        SendingStateDisplay.this.setToolTipText(Services.getText(1558));
                    } else {
                        SendingStateDisplay.this.setToolTipText(Services.getText(1513));
                    }
                } else {
                    SendingStateDisplay.this.setToolTipText(Services.getText(1514));
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e2) {
                if (e2.getButton() == 3) {
                    SendingStateDisplay.this.showPopUp(e2);
                }
            }

            @Override
            public void mousePressed(MouseEvent e2) {
                if (e2.getButton() != 1) {
                    return;
                }
                if (e2.getX() < 45) {
                    if (e2.getClickCount() != 1) {
                        return;
                    }
                    DocumentUtil.showAL(SendingStateDisplay.this.pm.getSending());
                } else if (e2.getX() > 78) {
                    if (e2.getClickCount() != 1) {
                        return;
                    }
                    DocumentUtil.showEvv(SendingStateDisplay.this.pm.getSending());
                } else {
                    SendingStateDisplay.this.pm.toggleInternalState();
                }
            }

            @Override
            public void mouseExited(MouseEvent e2) {
                Services.get(IGuiService.class).setLinkCursor(false);
            }
        });
    }

    private void addPmListener() {
        this.pm.add((INode<?> source, IChangeInfo info) -> this.repaint());
    }

    private void showPopUp(MouseEvent e2) {
        JPopupMenu menu = new JPopupMenu();
        menu.add(new DownloadAlAgainAction(this.pm.getSending()));
        menu.add(new SpediteurAction(this.pm.getSending()));
        menu.add(new GetEvvAction(this.pm.getSending()));
        menu.show(e2.getComponent(), e2.getX(), e2.getY());
    }

    @Override
    protected void paintComponent(Graphics g2) {
        Graphics2D g22 = (Graphics2D)g2;
        if (this.state.getOperatingMode() == OperatingMode.test) {
            this.drawIcon(g22, test, 2);
        }
        this.paintAl(g22);
        this.paintInternalState(g22);
        this.paintEVV(g22);
    }

    private void paintEVV(Graphics2D g2) {
        this.drawBorder(g2, 78);
        if (this.state.getEvvState() == EVVState.undefined) {
            if (this.state.isSelectedState()) {
                this.drawIcon(g2, point_green, 78);
            }
            return;
        }
        if (this.state.getEvvState() == EVVState.error) {
            this.drawIcon(g2, error, 78);
            return;
        }
        this.drawIcon(g2, this.state.isEvvMailed() ? evv_mailed : pdf, 78);
    }

    private void paintAl(Graphics2D g2) {
        this.drawBorder(g2, 12);
        if (this.state.getAlState() == ALState.undefined) {
            return;
        }
        if (this.state.getAlState() == ALState.error) {
            this.drawIcon(g2, error, 12);
        } else if (this.state.getAlState() == ALState.validated) {
            this.drawIcon(g2, check, 12);
        } else if (this.state.getAlState() == ALState.complete) {
            this.drawIcon(g2, pdf, 12);
        }
    }

    private void drawIcon(Graphics2D g2, ImageIcon icon, int x) {
        icon.paintIcon(this, g2, x + 2, 4);
    }

    private void drawBorder(Graphics2D g2, int x) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Design.STATUS_BORDER_BRIGHT);
        g2.drawRoundRect(x + 2, 3, 26, 27, 4, 4);
        g2.setColor(Design.STATUS_BORDER);
        g2.drawRoundRect(x + 1, 2, 26, 27, 4, 4);
    }

    private void paintInternalState(Graphics2D g2) {
        this.drawBorder(g2, 45);
        if (this.state.getInternalState() == InternalState.undefined) {
            return;
        }
        this.drawIcon(g2, truck, 45);
    }
}

