/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.sendinglist;

import ch.transsoft.edec.model.index.IndexEntry;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.gui.IGuiService;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.ui.gui.control.searchtable.SearchTable;
import ch.transsoft.edec.ui.gui.sendinglist.StateRenderer;
import ch.transsoft.edec.ui.gui.sendinglist.popupactions.IPopupMenuHandler;
import ch.transsoft.edec.ui.pm.sendinglist.IIndexTablePmListener;
import ch.transsoft.edec.ui.pm.sendinglist.IndexTablePmBase;
import ch.transsoft.edec.util.DocumentUtil;
import ch.transsoft.edec.util.TableUtil;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumn;
import org.jdesktop.swingx.decorator.SortOrder;
import org.jetbrains.annotations.Nullable;

public class IndexTablePanel
extends JScrollPane {
    private static final int STATUS_COL_WIDTH = 94;
    private static final int DATE_WIDTH = 75;
    private final SearchTable table;
    private final IndexTablePmBase pm;
    private final IPopupMenuHandler popupMenuHandler;

    public IndexTablePanel(IndexTablePmBase pm, IPopupMenuHandler popupMenuHandler) {
        this.pm = pm;
        this.popupMenuHandler = popupMenuHandler;
        this.table = new SearchTable(pm);
        this.setViewportView(this.table);
        this.table.setSelectionMode(2);
        this.table.setRowHeight(25);
        this.setAbsoluteWith(this.table.getColumn(0), 94);
        this.setAbsoluteWith(this.table.getColumn(1), 75);
        this.setAbsoluteWith(this.table.getColumn(2), 75);
        this.setAbsoluteWith(this.table.getColumn(3), 75);
        this.table.getColumnExt(0).setSortable(false);
        this.table.getColumn(0).setCellRenderer(new StateRenderer());
        this.table.setSortOrder(1, SortOrder.DESCENDING);
        this.addMouseListener();
        this.addPmListener();
        this.addActionListener();
        TableUtil.enableRightMouseButtonSelection(this.table);
        this.addPopupMenu();
    }

    private void setAbsoluteWith(TableColumn column, int with) {
        column.setMinWidth(with);
        column.setMaxWidth(with);
    }

    private void addActionListener() {
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e2) {
                if (!IndexTablePanel.this.table.hasSelectedRow()) {
                    return;
                }
                if (e2.getKeyChar() != '\n') {
                    return;
                }
                IndexTablePanel.this.pm.openSending(IndexTablePanel.this.table.getSelectionIndex());
                e2.consume();
            }
        });
    }

    private void addPopupMenu() {
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e2) {
                if (e2.getButton() == 3) {
                    IndexTablePanel.this.showMenu(e2);
                }
            }
        });
    }

    private void showMenu(MouseEvent e2) {
        if (!this.table.hasSelectedRow()) {
            return;
        }
        IndexEntry leadSelection = this.getLeadSelection();
        if (leadSelection == null) {
            return;
        }
        List<IndexEntry> selection = this.getSelection();
        JPopupMenu menu = new JPopupMenu();
        this.popupMenuHandler.addItems(leadSelection, selection, menu);
        if (menu.getComponentCount() == 0) {
            return;
        }
        try {
            menu.show(e2.getComponent(), e2.getX(), e2.getY());
        }
        catch (Exception ex) {
            Services.get(ILoggingService.class).logSilentWithBugMail(ex, "IndexTablePanel.showMenu threw.");
        }
    }

    private List<IndexEntry> getSelection() {
        ListSelectionModel model = this.table.getSelectionModel();
        ArrayList<IndexEntry> result = new ArrayList<IndexEntry>();
        for (int i2 = model.getMinSelectionIndex(); i2 <= model.getMaxSelectionIndex(); ++i2) {
            if (!model.isSelectedIndex(i2)) continue;
            int modelIndex = this.table.convertRowIndexToModel(i2);
            result.add(this.pm.getIndexEntry(modelIndex));
        }
        return result;
    }

    @Nullable
    private IndexEntry getLeadSelection() {
        int leadSelectionIndex = this.table.getSelectionModel().getLeadSelectionIndex();
        if (leadSelectionIndex == -1) {
            return null;
        }
        int modelIndex = this.table.convertRowIndexToModel(leadSelectionIndex);
        return this.pm.getIndexEntry(modelIndex);
    }

    private void addPmListener() {
        this.pm.add(new IIndexTablePmListener(){

            @Override
            public void searchTextChanged(String text) {
                IndexTablePanel.this.table.searchTextChanged(text);
            }

            @Override
            public void searchNext(boolean backwards) {
                IndexTablePanel.this.table.searchNext(backwards);
            }

            @Override
            public void openCurrentSending() {
                if (!IndexTablePanel.this.table.hasSelectedRow()) {
                    return;
                }
                IndexTablePanel.this.pm.openSending(IndexTablePanel.this.table.getSelectionIndex());
            }
        });
    }

    private void addMouseListener() {
        this.table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e2) {
                Services.get(IGuiService.class).setLinkCursor(IndexTablePanel.this.hitsClickableElement(e2));
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e2) {
                Services.get(IGuiService.class).setLinkCursor(false);
            }

            @Override
            public void mousePressed(MouseEvent e2) {
                if (e2.getButton() != 1) {
                    return;
                }
                if (!IndexTablePanel.this.table.hasSelectedRow()) {
                    return;
                }
                int row = IndexTablePanel.this.table.getSelectionIndex();
                if (e2.getClickCount() == 1) {
                    this.showDocument(row, e2);
                    return;
                }
                if (e2.getClickCount() == 2 && e2.getX() > 94) {
                    IndexTablePanel.this.pm.openSending(row);
                }
            }

            private void showDocument(int row, MouseEvent e2) {
                if (e2.getX() > 94) {
                    return;
                }
                IndexEntry entry = IndexTablePanel.this.pm.getIndexEntry(row);
                if (e2.getX() < 35) {
                    DocumentUtil.showAL(entry);
                } else if (e2.getX() > 60) {
                    DocumentUtil.showEvv(entry);
                }
            }
        });
    }

    private boolean hitsClickableElement(MouseEvent e2) {
        if (e2.getX() > 94) {
            return false;
        }
        int rowAtPoint = this.table.rowAtPoint(e2.getPoint());
        if (rowAtPoint == -1) {
            return false;
        }
        int row = this.table.convertRowIndexToModel(rowAtPoint);
        IndexEntry entry = this.pm.getIndexEntry(row);
        if (e2.getX() < 35) {
            return entry.getState().hasAl();
        }
        if (e2.getX() > 60) {
            return entry.getState().hasEvv();
        }
        return false;
    }
}

