/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.sendinglist.index;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.ui.gui.Design;
import ch.transsoft.edec.ui.gui.control.DefaultPanel;
import ch.transsoft.edec.ui.gui.control.Label;
import ch.transsoft.edec.ui.gui.control.icondisplay.IconDisplay;
import ch.transsoft.edec.ui.pm.sendinglist.IIndexSearchPm;
import ch.transsoft.edec.ui.pm.sendinglist.IndexTablePmBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;

public class IndexSearchPanel
extends DefaultPanel {
    private JTextField field;
    private IconDisplay deleteButton;
    private final IIndexSearchPm pm;

    public IndexSearchPanel(IIndexSearchPm pm) {
        this.pm = pm;
        this.setLayout(new MigLayout("", "[]push[]2[]"));
        this.add(new Label(Services.getText(1516), true));
        this.field = new JTextField();
        this.add((Component)this.field, "width 140!");
        this.field.setDocument(pm.getSearchModel());
        this.field.setForeground(Color.GRAY);
        this.deleteButton = new IconDisplay("icon/Delete-Table-small.png", 0);
        this.add((Component)this.deleteButton, "width 16!, height 16!");
        this.addDeleteListener();
        this.addSearchListener();
        this.addChangeListener();
    }

    private void addChangeListener() {
        this.pm.getSearchModel().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e2) {
                IndexSearchPanel.this.updateColor();
            }

            @Override
            public void insertUpdate(DocumentEvent e2) {
                IndexSearchPanel.this.updateColor();
            }

            @Override
            public void changedUpdate(DocumentEvent e2) {
            }
        });
    }

    private void updateColor() {
        if (this.field.getText().isEmpty()) {
            this.field.setBackground(Color.WHITE);
            this.field.setForeground(Color.BLACK);
        } else {
            this.field.setBackground(Design.SEARCH_BG);
            this.field.setForeground(Design.SEARCH_FG);
        }
    }

    private void addDeleteListener() {
        this.deleteButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                IndexSearchPanel.this.pm.clearSearch();
                IndexSearchPanel.this.field.requestFocus();
            }
        });
    }

    private void addSearchListener() {
        this.field.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e2) {
            }

            @Override
            public void keyReleased(KeyEvent e2) {
            }

            @Override
            public void keyPressed(KeyEvent e2) {
                if (e2.getKeyCode() == 38) {
                    IndexSearchPanel.this.pm.notifySearchNext(true);
                } else if (e2.getKeyCode() == 40) {
                    IndexSearchPanel.this.pm.notifySearchNext(false);
                } else if (e2.getKeyCode() == 10) {
                    IndexSearchPanel.this.pm.notifyOpenCurrentSending();
                }
            }
        });
        this.field.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e2) {
            }

            @Override
            public void focusGained(FocusEvent e2) {
                if (IndexSearchPanel.this.field.getText().equals(IndexTablePmBase.SERACH)) {
                    IndexSearchPanel.this.field.setText("");
                }
                IndexSearchPanel.this.field.select(0, IndexSearchPanel.this.field.getText().length());
            }
        });
    }
}

