/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.gui.sendinglist.popupactions;

import ch.transsoft.edec.model.index.IndexEntry;
import ch.transsoft.edec.model.sending.OperatingMode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.action.ActionBase;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.backend.jobs.evv.FetchEvvJob;
import ch.transsoft.edec.service.config.IConfigService;
import java.awt.event.ActionEvent;

public class FetchEvvAction
extends ActionBase {
    private IndexEntry entry;

    public FetchEvvAction(IndexEntry entry) {
        super(Services.getText(1508), "icon/evv-small.png", "icon/evv-big.png");
        this.entry = entry;
        if (!Services.get(IConfigService.class).hasCertificate()) {
            this.setEnabled(false);
            this.setTooltip(Services.getText(3038));
        } else if (entry.getState().hasAl() || entry.getState().hasEvv()) {
            this.setEnabled(true);
            this.setTooltip(null);
        } else {
            this.setEnabled(false);
            this.setTooltip(Services.getText(1509));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        OperatingMode operatingMode = this.entry.getOperatingModeValue();
        String sendingId = this.entry.getSendingId();
        String customsDeclarationNumber = this.entry.getCustomsDeclarationNumber().getValue();
        Services.get(IBackendService.class).put(new FetchEvvJob(operatingMode, sendingId, customsDeclarationNumber, false));
    }
}

